//START AjaxControlToolkit.Common.Common.js
Type.registerNamespace("AjaxControlToolkit");
AjaxControlToolkit.BoxSide = function() {}
;
AjaxControlToolkit.BoxSide.prototype = {
    Top: 0,
    Right: 1,
    Bottom: 2,
    Left: 3
};
AjaxControlToolkit.BoxSide.registerEnum("AjaxControlToolkit.BoxSide", false);
AjaxControlToolkit._CommonToolkitScripts = function() {}
;
AjaxControlToolkit._CommonToolkitScripts.prototype = {
    _borderStyleNames: ["borderTopStyle", "borderRightStyle", "borderBottomStyle", "borderLeftStyle"],
    _borderWidthNames: ["borderTopWidth", "borderRightWidth", "borderBottomWidth", "borderLeftWidth"],
    _paddingWidthNames: ["paddingTop", "paddingRight", "paddingBottom", "paddingLeft"],
    _marginWidthNames: ["marginTop", "marginRight", "marginBottom", "marginLeft"],
    getCurrentStyle: function(b, c, e) {
        var d = "undefined"
          , a = null;
        if (b) {
            if (b.currentStyle)
                a = b.currentStyle[c];
            else if (document.defaultView && document.defaultView.getComputedStyle) {
                var f = document.defaultView.getComputedStyle(b, null);
                if (f)
                    a = f[c]
            }
            if (!a && b.style.getPropertyValue)
                a = b.style.getPropertyValue(c);
            else if (!a && b.style.getAttribute)
                a = b.style.getAttribute(c)
        }
        if (!a || a == "" || typeof a === d)
            if (typeof e != d)
                a = e;
            else
                a = null;
        return a
    },
    getInheritedBackgroundColor: function(b) {
        var d = "backgroundColor"
          , c = "#FFFFFF";
        if (!b)
            return c;
        var a = this.getCurrentStyle(b, d);
        try {
            while (!a || a == "" || a == "transparent" || a == "rgba(0, 0, 0, 0)") {
                b = b.parentNode;
                if (!b)
                    a = c;
                else
                    a = this.getCurrentStyle(b, d)
            }
        } catch (e) {
            a = c
        }
        return a
    },
    getLocation: function(a) {
        return Sys.UI.DomElement.getLocation(a)
    },
    setLocation: function(b, a) {
        Sys.UI.DomElement.setLocation(b, a.x, a.y)
    },
    getContentSize: function(a) {
        if (!a)
            throw Error.argumentNull("element");
        var d = this.getSize(a)
          , c = this.getBorderBox(a)
          , b = this.getPaddingBox(a);
        return {
            width: d.width - c.horizontal - b.horizontal,
            height: d.height - c.vertical - b.vertical
        }
    },
    getSize: function(a) {
        if (!a)
            throw Error.argumentNull("element");
        return {
            width: a.offsetWidth,
            height: a.offsetHeight
        }
    },
    setContentSize: function(a, b) {
        var d = "border-box"
          , c = this;
        if (!a)
            throw Error.argumentNull("element");
        if (!b)
            throw Error.argumentNull("size");
        if (c.getCurrentStyle(a, "MozBoxSizing") == d || c.getCurrentStyle(a, "BoxSizing") == d) {
            var f = c.getBorderBox(a)
              , e = c.getPaddingBox(a);
            b = {
                width: b.width + f.horizontal + e.horizontal,
                height: b.height + f.vertical + e.vertical
            }
        }
        a.style.width = b.width.toString() + "px";
        a.style.height = b.height.toString() + "px"
    },
    setSize: function(a, b) {
        if (!a)
            throw Error.argumentNull("element");
        if (!b)
            throw Error.argumentNull("size");
        var d = this.getBorderBox(a)
          , c = this.getPaddingBox(a)
          , e = {
            width: b.width - d.horizontal - c.horizontal,
            height: b.height - d.vertical - c.vertical
        };
        this.setContentSize(a, e)
    },
    getBounds: function(a) {
        return Sys.UI.DomElement.getBounds(a)
    },
    setBounds: function(a, b) {
        if (!a)
            throw Error.argumentNull("element");
        if (!b)
            throw Error.argumentNull("bounds");
        this.setSize(a, b);
        $common.setLocation(a, b)
    },
    getClientBounds: function() {
        var b, a;
        if (document.compatMode == "CSS1Compat") {
            b = document.documentElement.clientWidth;
            a = document.documentElement.clientHeight
        } else {
            b = document.body.clientWidth;
            a = document.body.clientHeight
        }
        return new Sys.UI.Bounds(0,0,b,a)
    },
    getMarginBox: function(b) {
        var c = this;
        if (!b)
            throw Error.argumentNull("element");
        var a = {
            top: c.getMargin(b, AjaxControlToolkit.BoxSide.Top),
            right: c.getMargin(b, AjaxControlToolkit.BoxSide.Right),
            bottom: c.getMargin(b, AjaxControlToolkit.BoxSide.Bottom),
            left: c.getMargin(b, AjaxControlToolkit.BoxSide.Left)
        };
        a.horizontal = a.left + a.right;
        a.vertical = a.top + a.bottom;
        return a
    },
    getBorderBox: function(b) {
        var c = this;
        if (!b)
            throw Error.argumentNull("element");
        var a = {
            top: c.getBorderWidth(b, AjaxControlToolkit.BoxSide.Top),
            right: c.getBorderWidth(b, AjaxControlToolkit.BoxSide.Right),
            bottom: c.getBorderWidth(b, AjaxControlToolkit.BoxSide.Bottom),
            left: c.getBorderWidth(b, AjaxControlToolkit.BoxSide.Left)
        };
        a.horizontal = a.left + a.right;
        a.vertical = a.top + a.bottom;
        return a
    },
    getPaddingBox: function(b) {
        var c = this;
        if (!b)
            throw Error.argumentNull("element");
        var a = {
            top: c.getPadding(b, AjaxControlToolkit.BoxSide.Top),
            right: c.getPadding(b, AjaxControlToolkit.BoxSide.Right),
            bottom: c.getPadding(b, AjaxControlToolkit.BoxSide.Bottom),
            left: c.getPadding(b, AjaxControlToolkit.BoxSide.Left)
        };
        a.horizontal = a.left + a.right;
        a.vertical = a.top + a.bottom;
        return a
    },
    isBorderVisible: function(b, a) {
        if (!b)
            throw Error.argumentNull("element");
        if (a < AjaxControlToolkit.BoxSide.Top || a > AjaxControlToolkit.BoxSide.Left)
            throw Error.argumentOutOfRange(String.format(Sys.Res.enumInvalidValue, a, "AjaxControlToolkit.BoxSide"));
        var d = this._borderStyleNames[a]
          , c = this.getCurrentStyle(b, d);
        return c != "none"
    },
    getMargin: function(b, a) {
        if (!b)
            throw Error.argumentNull("element");
        if (a < AjaxControlToolkit.BoxSide.Top || a > AjaxControlToolkit.BoxSide.Left)
            throw Error.argumentOutOfRange(String.format(Sys.Res.enumInvalidValue, a, "AjaxControlToolkit.BoxSide"));
        var d = this._marginWidthNames[a]
          , c = this.getCurrentStyle(b, d);
        try {
            return this.parsePadding(c)
        } catch (e) {
            return 0
        }
    },
    getBorderWidth: function(c, a) {
        var b = this;
        if (!c)
            throw Error.argumentNull("element");
        if (a < AjaxControlToolkit.BoxSide.Top || a > AjaxControlToolkit.BoxSide.Left)
            throw Error.argumentOutOfRange(String.format(Sys.Res.enumInvalidValue, a, "AjaxControlToolkit.BoxSide"));
        if (!b.isBorderVisible(c, a))
            return 0;
        var e = b._borderWidthNames[a]
          , d = b.getCurrentStyle(c, e);
        return b.parseBorderWidth(d)
    },
    getPadding: function(b, a) {
        if (!b)
            throw Error.argumentNull("element");
        if (a < AjaxControlToolkit.BoxSide.Top || a > AjaxControlToolkit.BoxSide.Left)
            throw Error.argumentOutOfRange(String.format(Sys.Res.enumInvalidValue, a, "AjaxControlToolkit.BoxSide"));
        var d = this._paddingWidthNames[a]
          , c = this.getCurrentStyle(b, d);
        return this.parsePadding(c)
    },
    parseBorderWidth: function(d) {
        var h = "thick"
          , g = "medium"
          , f = "thin"
          , e = this;
        if (!e._borderThicknesses) {
            var c = {}
              , a = document.createElement("div");
            a.style.visibility = "hidden";
            a.style.position = "absolute";
            a.style.fontSize = "1px";
            document.body.appendChild(a);
            var b = document.createElement("div");
            b.style.height = "0px";
            b.style.overflow = "hidden";
            a.appendChild(b);
            var i = a.offsetHeight;
            b.style.borderTop = "solid black";
            b.style.borderTopWidth = f;
            c[f] = a.offsetHeight - i;
            b.style.borderTopWidth = g;
            c[g] = a.offsetHeight - i;
            b.style.borderTopWidth = h;
            c[h] = a.offsetHeight - i;
            a.removeChild(b);
            document.body.removeChild(a);
            e._borderThicknesses = c
        }
        if (d) {
            switch (d) {
            case f:
            case g:
            case h:
                return e._borderThicknesses[d];
            case "inherit":
                return 0
            }
            var j = e.parseUnit(d);
            Sys.Debug.assert(j.type == "px", String.format(AjaxControlToolkit.Resources.Common_InvalidBorderWidthUnit, j.type));
            return j.size
        }
        return 0
    },
    parsePadding: function(a) {
        if (a) {
            if (a == "inherit")
                return 0;
            var b = this.parseUnit(a);
            Sys.Debug.assert(b.type == "px", String.format(AjaxControlToolkit.Resources.Common_InvalidPaddingUnit, b.type));
            return b.size
        }
        return 0
    },
    parseUnit: function(a) {
        if (!a)
            throw Error.argumentNull("value");
        a = a.trim().toLowerCase();
        for (var g = a.length, c = -1, f = 0; f < g; f++) {
            var b = a.substr(f, 1);
            if ((b < "0" || b > "9") && b != "-" && b != "." && b != ",")
                break;
            c = f
        }
        if (c == -1)
            throw Error.create(AjaxControlToolkit.Resources.Common_UnitHasNoDigits);
        var e, d;
        if (c < g - 1)
            e = a.substring(c + 1).trim();
        else
            e = "px";
        d = parseFloat(a.substr(0, c + 1));
        if (e == "px")
            d = Math.floor(d);
        return {
            size: d,
            type: e
        }
    },
    getElementOpacity: function(a) {
        if (!a)
            throw Error.argumentNull("element");
        var b = false, c;
        if (a.filters) {
            var e = a.filters;
            if (e.length !== 0) {
                var d = e["DXImageTransform.Microsoft.Alpha"];
                if (d) {
                    c = d.opacity / 100;
                    b = true
                }
            }
        } else {
            c = this.getCurrentStyle(a, "opacity", 1);
            b = true
        }
        if (b === false)
            return 1;
        return parseFloat(c)
    },
    setElementOpacity: function(a, b) {
        if (!a)
            throw Error.argumentNull("element");
        if (a.filters) {
            var e = a.filters
              , c = true;
            if (e.length !== 0) {
                var d = e["DXImageTransform.Microsoft.Alpha"];
                if (d) {
                    c = false;
                    d.opacity = b * 100
                }
            }
            if (c)
                a.style.filter = "progid:DXImageTransform.Microsoft.Alpha(opacity=" + b * 100 + ")"
        } else
            a.style.opacity = b
    },
    getVisible: function(a) {
        return a && "none" != $common.getCurrentStyle(a, "display") && "hidden" != $common.getCurrentStyle(a, "visibility")
    },
    setVisible: function(a, b) {
        if (a && b != $common.getVisible(a)) {
            if (b)
                if (a.style.removeAttribute)
                    a.style.removeAttribute("display");
                else
                    a.style.removeProperty("display");
            else
                a.style.display = "none";
            a.style.visibility = b ? "visible" : "hidden"
        }
    },
    resolveFunction: function(value) {
        if (value)
            if (value instanceof Function)
                return value;
            else if (String.isInstanceOfType(value) && value.length > 0) {
                var func;
                if ((func = window[value])instanceof Function)
                    return func;
                else if ((func = eval(value))instanceof Function)
                    return func
            }
        return null
    },
    addCssClasses: function(c, b) {
        for (var a = 0; a < b.length; a++)
            Sys.UI.DomElement.addCssClass(c, b[a])
    },
    removeCssClasses: function(c, b) {
        for (var a = 0; a < b.length; a++)
            Sys.UI.DomElement.removeCssClass(c, b[a])
    },
    setStyle: function(a, b) {
        $common.applyProperties(a.style, b)
    },
    removeHandlers: function(c, a) {
        for (var b in a)
            $removeHandler(c, b, a[b])
    },
    overlaps: function(a, b) {
        return a.x < b.x + b.width && b.x < a.x + a.width && a.y < b.y + b.height && b.y < a.y + a.height
    },
    containsPoint: function(a, b, c) {
        return b >= a.x && b < a.x + a.width && c >= a.y && c < a.y + a.height
    },
    isKeyDigit: function(a) {
        return 48 <= a && a <= 57
    },
    isKeyNavigation: function(a) {
        return Sys.UI.Key.left <= a && a <= Sys.UI.Key.down
    },
    padLeft: function(c, b, d, a) {
        return $common._pad(c, b || 2, d || " ", "l", a || false)
    },
    padRight: function(c, b, d, a) {
        return $common._pad(c, b || 2, d || " ", "r", a || false)
    },
    _pad: function(c, b, h, e, g) {
        c = c.toString();
        var f = c.length
          , d = new Sys.StringBuilder;
        e == "r" && d.append(c);
        while (f < b) {
            d.append(h);
            f++
        }
        e == "l" && d.append(c);
        var a = d.toString();
        if (g && a.length > b)
            if (e == "l")
                a = a.substr(a.length - b, b);
            else
                a = a.substr(0, b);
        return a
    },
    __DOMEvents: {
        focusin: {
            eventGroup: "UIEvents",
            init: function(a) {
                a.initUIEvent("focusin", true, false, window, 1)
            }
        },
        focusout: {
            eventGroup: "UIEvents",
            init: function(a) {
                a.initUIEvent("focusout", true, false, window, 1)
            }
        },
        activate: {
            eventGroup: "UIEvents",
            init: function(a) {
                a.initUIEvent("activate", true, true, window, 1)
            }
        },
        focus: {
            eventGroup: "UIEvents",
            init: function(a) {
                a.initUIEvent("focus", false, false, window, 1)
            }
        },
        blur: {
            eventGroup: "UIEvents",
            init: function(a) {
                a.initUIEvent("blur", false, false, window, 1)
            }
        },
        click: {
            eventGroup: "MouseEvents",
            init: function(c, a) {
                var b = false;
                c.initMouseEvent("click", true, true, window, 1, a.screenX || 0, a.screenY || 0, a.clientX || 0, a.clientY || 0, a.ctrlKey || b, a.altKey || b, a.shiftKey || b, a.metaKey || b, a.button || 0, a.relatedTarget || null)
            }
        },
        dblclick: {
            eventGroup: "MouseEvents",
            init: function(c, a) {
                var b = false;
                c.initMouseEvent("click", true, true, window, 2, a.screenX || 0, a.screenY || 0, a.clientX || 0, a.clientY || 0, a.ctrlKey || b, a.altKey || b, a.shiftKey || b, a.metaKey || b, a.button || 0, a.relatedTarget || null)
            }
        },
        mousedown: {
            eventGroup: "MouseEvents",
            init: function(c, a) {
                var b = false;
                c.initMouseEvent("mousedown", true, true, window, 1, a.screenX || 0, a.screenY || 0, a.clientX || 0, a.clientY || 0, a.ctrlKey || b, a.altKey || b, a.shiftKey || b, a.metaKey || b, a.button || 0, a.relatedTarget || null)
            }
        },
        mouseup: {
            eventGroup: "MouseEvents",
            init: function(c, a) {
                var b = false;
                c.initMouseEvent("mouseup", true, true, window, 1, a.screenX || 0, a.screenY || 0, a.clientX || 0, a.clientY || 0, a.ctrlKey || b, a.altKey || b, a.shiftKey || b, a.metaKey || b, a.button || 0, a.relatedTarget || null)
            }
        },
        mouseover: {
            eventGroup: "MouseEvents",
            init: function(c, a) {
                var b = false;
                c.initMouseEvent("mouseover", true, true, window, 1, a.screenX || 0, a.screenY || 0, a.clientX || 0, a.clientY || 0, a.ctrlKey || b, a.altKey || b, a.shiftKey || b, a.metaKey || b, a.button || 0, a.relatedTarget || null)
            }
        },
        mousemove: {
            eventGroup: "MouseEvents",
            init: function(c, a) {
                var b = false;
                c.initMouseEvent("mousemove", true, true, window, 1, a.screenX || 0, a.screenY || 0, a.clientX || 0, a.clientY || 0, a.ctrlKey || b, a.altKey || b, a.shiftKey || b, a.metaKey || b, a.button || 0, a.relatedTarget || null)
            }
        },
        mouseout: {
            eventGroup: "MouseEvents",
            init: function(c, a) {
                var b = false;
                c.initMouseEvent("mousemove", true, true, window, 1, a.screenX || 0, a.screenY || 0, a.clientX || 0, a.clientY || 0, a.ctrlKey || b, a.altKey || b, a.shiftKey || b, a.metaKey || b, a.button || 0, a.relatedTarget || null)
            }
        },
        load: {
            eventGroup: "HTMLEvents",
            init: function(a) {
                a.initEvent("load", false, false)
            }
        },
        unload: {
            eventGroup: "HTMLEvents",
            init: function(a) {
                a.initEvent("unload", false, false)
            }
        },
        select: {
            eventGroup: "HTMLEvents",
            init: function(a) {
                a.initEvent("select", true, false)
            }
        },
        change: {
            eventGroup: "HTMLEvents",
            init: function(a) {
                a.initEvent("change", true, false)
            }
        },
        submit: {
            eventGroup: "HTMLEvents",
            init: function(a) {
                a.initEvent("submit", true, true)
            }
        },
        reset: {
            eventGroup: "HTMLEvents",
            init: function(a) {
                a.initEvent("reset", true, false)
            }
        },
        resize: {
            eventGroup: "HTMLEvents",
            init: function(a) {
                a.initEvent("resize", true, false)
            }
        },
        scroll: {
            eventGroup: "HTMLEvents",
            init: function(a) {
                a.initEvent("scroll", true, false)
            }
        }
    },
    tryFireRawEvent: function(a, b) {
        try {
            if (a.fireEvent) {
                a.fireEvent("on" + b.type, b);
                return true
            } else if (a.dispatchEvent) {
                a.dispatchEvent(b);
                return true
            }
        } catch (c) {}
        return false
    },
    tryFireEvent: function(e, d, c) {
        try {
            if (document.createEventObject) {
                var a = document.createEventObject();
                $common.applyProperties(a, c || {});
                e.fireEvent("on" + d, a);
                return true
            } else if (document.createEvent) {
                var b = $common.__DOMEvents[d];
                if (b) {
                    var a = document.createEvent(b.eventGroup);
                    b.init(a, c || {});
                    e.dispatchEvent(a);
                    return true
                }
            }
        } catch (f) {}
        return false
    },
    wrapElement: function(a, b, c) {
        var d = a.parentNode;
        d.replaceChild(b, a);
        (c || b).appendChild(a)
    },
    unwrapElement: function(b, a) {
        var c = a.parentNode;
        if (c != null) {
            $common.removeElement(b);
            c.replaceChild(b, a)
        }
    },
    removeElement: function(a) {
        var b = a.parentNode;
        b != null && b.removeChild(a)
    },
    applyProperties: function(d, c) {
        for (var b in c) {
            var a = c[b];
            if (a != null && Object.getType(a) === Object) {
                var e = d[b];
                $common.applyProperties(e, a)
            } else
                d[b] = a
        }
    },
    createElementFromTemplate: function(a, j, e) {
        var c = null
          , b = "undefined";
        if (typeof a.nameTable != b) {
            var g = a.nameTable;
            if (String.isInstanceOfType(g))
                g = e[g];
            if (g != c)
                e = g
        }
        var l = c;
        if (typeof a.name !== b)
            l = a.name;
        var d = document.createElement(a.nodeName);
        if (typeof a.name !== b && e)
            e[a.name] = d;
        if (typeof a.parent !== b && j == c) {
            var h = a.parent;
            if (String.isInstanceOfType(h))
                h = e[h];
            if (h != c)
                j = h
        }
        typeof a.properties !== b && a.properties != c && $common.applyProperties(d, a.properties);
        typeof a.cssClasses !== b && a.cssClasses != c && $common.addCssClasses(d, a.cssClasses);
        typeof a.events !== b && a.events != c && $addHandlers(d, a.events);
        typeof a.visible !== b && a.visible != c && this.setVisible(d, a.visible);
        j && j.appendChild(d);
        typeof a.opacity !== b && a.opacity != c && $common.setElementOpacity(d, a.opacity);
        if (typeof a.children !== b && a.children != c)
            for (var k = 0; k < a.children.length; k++) {
                var m = a.children[k];
                $common.createElementFromTemplate(m, d, e)
            }
        var i = d;
        if (typeof a.contentPresenter !== b && a.contentPresenter != c)
            i = e[i];
        if (typeof a.content !== b && a.content != c) {
            var f = a.content;
            if (String.isInstanceOfType(f))
                f = e[f];
            if (f.parentNode)
                $common.wrapElement(f, d, i);
            else
                i.appendChild(f)
        }
        return d
    },
    prepareHiddenElementForATDeviceUpdate: function() {
        var b = "hiddenInputToUpdateATBuffer_CommonToolkitScripts"
          , a = document.getElementById(b);
        if (!a) {
            var a = document.createElement("input");
            a.setAttribute("type", "hidden");
            a.setAttribute("value", "1");
            a.setAttribute("id", b);
            a.setAttribute("name", b);
            document.forms[0] && document.forms[0].appendChild(a)
        }
    },
    updateFormToRefreshATDeviceBuffer: function() {
        var b = "value"
          , a = document.getElementById("hiddenInputToUpdateATBuffer_CommonToolkitScripts");
        if (a)
            if (a.getAttribute(b) == "1")
                a.setAttribute(b, "0");
            else
                a.setAttribute(b, "1")
    },
    appendElementToFormOrBody: function(a) {
        if (document.forms && document.forms[0])
            document.forms[0].appendChild(a);
        else
            document.body.appendChild(a)
    }
};
if (document.documentElement.getBoundingClientRect)
    Sys.UI.DomElement.getLocation = function(b) {
        if (b.self || b.nodeType === 9 || b === document.documentElement || b.parentNode === b.ownerDocument.documentElement)
            return new Sys.UI.Point(0,0);
        var f = b.getBoundingClientRect();
        if (!f)
            return new Sys.UI.Point(0,0);
        var k, e = b.ownerDocument.documentElement, c = Math.round(f.left) + e.scrollLeft, d = Math.round(f.top) + e.scrollTop;
        if (Sys.Browser.agent === Sys.Browser.InternetExplorer) {
            try {
                var g = b.ownerDocument.parentWindow.frameElement || null;
                if (g) {
                    var h = g.frameBorder === "0" || g.frameBorder === "no" ? 2 : 0;
                    c += h;
                    d += h
                }
            } catch (l) {}
            if (Sys.Browser.version === 7 && !document.documentMode) {
                var i = document.body
                  , j = i.getBoundingClientRect()
                  , a = (j.right - j.left) / i.clientWidth;
                a = Math.round(a * 100);
                a = (a - a % 5) / 100;
                if (!isNaN(a) && a !== 1) {
                    c = Math.round(c / a);
                    d = Math.round(d / a)
                }
            }
            if ((document.documentMode || 0) < 8) {
                c -= e.clientLeft;
                d -= e.clientTop
            }
        }
        return new Sys.UI.Point(c,d)
    }
    ;
else if (Sys.Browser.agent === Sys.Browser.Safari)
    Sys.UI.DomElement.getLocation = function(c) {
        var i = "absolute"
          , d = null;
        if (c.window && c.window === c || c.nodeType === 9)
            return new Sys.UI.Point(0,0);
        for (var e = 0, f = 0, l = d, h = d, b, a = c; a; l = a,
        h = b,
        a = a.offsetParent) {
            b = Sys.UI.DomElement._getCurrentStyle(a);
            var g = a.tagName ? a.tagName.toUpperCase() : d;
            if ((a.offsetLeft || a.offsetTop) && (g !== "BODY" || (!h || h.position !== i))) {
                e += a.offsetLeft;
                f += a.offsetTop
            }
            if (l && Sys.Browser.version >= 3) {
                e += parseInt(b.borderLeftWidth);
                f += parseInt(b.borderTopWidth)
            }
        }
        b = Sys.UI.DomElement._getCurrentStyle(c);
        var j = b ? b.position : d;
        if (!j || j !== i)
            for (a = c.parentNode; a; a = a.parentNode) {
                g = a.tagName ? a.tagName.toUpperCase() : d;
                if (g !== "BODY" && g !== "HTML" && (a.scrollLeft || a.scrollTop)) {
                    e -= a.scrollLeft || 0;
                    f -= a.scrollTop || 0
                }
                b = Sys.UI.DomElement._getCurrentStyle(a);
                var k = b ? b.position : d;
                if (k && k === i)
                    break
            }
        return new Sys.UI.Point(e,f)
    }
    ;
else
    Sys.UI.DomElement.getLocation = function(e) {
        var i = "absolute"
          , d = null;
        if (e.window && e.window === e || e.nodeType === 9)
            return new Sys.UI.Point(0,0);
        for (var f = 0, g = 0, k = d, h = d, b = d, a = e; a; k = a,
        h = b,
        a = a.offsetParent) {
            var c = a.tagName ? a.tagName.toUpperCase() : d;
            b = Sys.UI.DomElement._getCurrentStyle(a);
            if ((a.offsetLeft || a.offsetTop) && !(c === "BODY" && (!h || h.position !== i))) {
                f += a.offsetLeft;
                g += a.offsetTop
            }
            if (k !== d && b) {
                if (c !== "TABLE" && c !== "TD" && c !== "HTML") {
                    f += parseInt(b.borderLeftWidth) || 0;
                    g += parseInt(b.borderTopWidth) || 0
                }
                if (c === "TABLE" && (b.position === "relative" || b.position === i)) {
                    f += parseInt(b.marginLeft) || 0;
                    g += parseInt(b.marginTop) || 0
                }
            }
        }
        b = Sys.UI.DomElement._getCurrentStyle(e);
        var j = b ? b.position : d;
        if (!j || j !== i)
            for (a = e.parentNode; a; a = a.parentNode) {
                c = a.tagName ? a.tagName.toUpperCase() : d;
                if (c !== "BODY" && c !== "HTML" && (a.scrollLeft || a.scrollTop)) {
                    f -= a.scrollLeft || 0;
                    g -= a.scrollTop || 0;
                    b = Sys.UI.DomElement._getCurrentStyle(a);
                    if (b) {
                        f += parseInt(b.borderLeftWidth) || 0;
                        g += parseInt(b.borderTopWidth) || 0
                    }
                }
            }
        return new Sys.UI.Point(f,g)
    }
    ;
var CommonToolkitScripts = AjaxControlToolkit.CommonToolkitScripts = new AjaxControlToolkit._CommonToolkitScripts
  , $common = CommonToolkitScripts;
Sys.UI.DomElement.getVisible = $common.getVisible;
Sys.UI.DomElement.setVisible = $common.setVisible;
Sys.UI.Control.overlaps = $common.overlaps;
AjaxControlToolkit._DomUtility = function() {}
;
AjaxControlToolkit._DomUtility.prototype = {
    isDescendant: function(c, b) {
        for (var a = b.parentNode; a != null; a = a.parentNode)
            if (a == c)
                return true;
        return false
    },
    isDescendantOrSelf: function(b, a) {
        if (b === a)
            return true;
        return AjaxControlToolkit.DomUtility.isDescendant(b, a)
    },
    isAncestor: function(a, b) {
        return AjaxControlToolkit.DomUtility.isDescendant(b, a)
    },
    isAncestorOrSelf: function(a, b) {
        if (a === b)
            return true;
        return AjaxControlToolkit.DomUtility.isDescendant(b, a)
    },
    isSibling: function(d, c) {
        for (var b = d.parentNode, a = 0; a < b.childNodes.length; a++)
            if (b.childNodes[a] == c)
                return true;
        return false
    }
};
AjaxControlToolkit._DomUtility.registerClass("AjaxControlToolkit._DomUtility");
AjaxControlToolkit.DomUtility = new AjaxControlToolkit._DomUtility;
AjaxControlToolkit.TextBoxWrapper = function(b) {
    var a = this;
    AjaxControlToolkit.TextBoxWrapper.initializeBase(a, [b]);
    a._current = b.value;
    a._watermark = null;
    a._isWatermarked = false
}
;
AjaxControlToolkit.TextBoxWrapper.prototype = {
    dispose: function() {
        this.get_element().AjaxControlToolkitTextBoxWrapper = null;
        AjaxControlToolkit.TextBoxWrapper.callBaseMethod(this, "dispose")
    },
    get_Current: function() {
        this._current = this.get_element().value;
        return this._current
    },
    set_Current: function(a) {
        this._current = a;
        this._updateElement()
    },
    get_Value: function() {
        if (this.get_IsWatermarked())
            return "";
        else
            return this.get_Current()
    },
    set_Value: function(b) {
        var a = this;
        a.set_Current(b);
        if (!b || 0 == b.length)
            null != a._watermark && a.set_IsWatermarked(true);
        else
            a.set_IsWatermarked(false)
    },
    get_Watermark: function() {
        return this._watermark
    },
    set_Watermark: function(a) {
        this._watermark = a;
        this._updateElement()
    },
    get_IsWatermarked: function() {
        return this._isWatermarked
    },
    set_IsWatermarked: function(b) {
        var a = this;
        if (a._isWatermarked != b) {
            a._isWatermarked = b;
            a._updateElement();
            a._raiseWatermarkChanged()
        }
    },
    _updateElement: function() {
        var a = this
          , b = a.get_element();
        if (a._isWatermarked) {
            if (b.value != a._watermark)
                b.value = a._watermark
        } else if (b.value != a._current)
            b.value = a._current
    },
    add_WatermarkChanged: function(a) {
        this.get_events().addHandler("WatermarkChanged", a)
    },
    remove_WatermarkChanged: function(a) {
        this.get_events().removeHandler("WatermarkChanged", a)
    },
    _raiseWatermarkChanged: function() {
        var a = this.get_events().getHandler("WatermarkChanged");
        a && a(this, Sys.EventArgs.Empty)
    }
};
AjaxControlToolkit.TextBoxWrapper.get_Wrapper = function(a) {
    if (null == a.AjaxControlToolkitTextBoxWrapper)
        a.AjaxControlToolkitTextBoxWrapper = new AjaxControlToolkit.TextBoxWrapper(a);
    return a.AjaxControlToolkitTextBoxWrapper
}
;
AjaxControlToolkit.TextBoxWrapper.registerClass("AjaxControlToolkit.TextBoxWrapper", Sys.UI.Behavior);
AjaxControlToolkit.TextBoxWrapper.validatorGetValue = function(b) {
    var a = $get(b);
    if (a && a.AjaxControlToolkitTextBoxWrapper)
        return a.AjaxControlToolkitTextBoxWrapper.get_Value();
    return AjaxControlToolkit.TextBoxWrapper._originalValidatorGetValue(b)
}
;
if (typeof ValidatorGetValue == "function") {
    AjaxControlToolkit.TextBoxWrapper._originalValidatorGetValue = ValidatorGetValue;
    ValidatorGetValue = AjaxControlToolkit.TextBoxWrapper.validatorGetValue
}
if (Sys.CultureInfo.prototype._getAbbrMonthIndex) {
    Sys.CultureInfo.prototype._getAbbrMonthIndex = function(b) {
        var a = this;
        if (!a._upperAbbrMonths)
            a._upperAbbrMonths = a._toUpperArray(a.dateTimeFormat.AbbreviatedMonthNames);
        return Array.indexOf(a._upperAbbrMonths, a._toUpper(b))
    }
    ;
    Sys.CultureInfo.CurrentCulture._getAbbrMonthIndex = Sys.CultureInfo.prototype._getAbbrMonthIndex;
    Sys.CultureInfo.InvariantCulture._getAbbrMonthIndex = Sys.CultureInfo.prototype._getAbbrMonthIndex
}
;//END AjaxControlToolkit.Common.Common.js
//START AjaxControlToolkit.Common.DateTime.js
Type.registerNamespace("AjaxControlToolkit");
AjaxControlToolkit.TimeSpan = function() {
    var a = this;
    if (arguments.length == 0)
        a._ctor$0.apply(a, arguments);
    else if (arguments.length == 1)
        a._ctor$1.apply(a, arguments);
    else if (arguments.length == 3)
        a._ctor$2.apply(a, arguments);
    else if (arguments.length == 4)
        a._ctor$3.apply(a, arguments);
    else if (arguments.length == 5)
        a._ctor$4.apply(a, arguments);
    else
        throw Error.parameterCount();
}
;
AjaxControlToolkit.TimeSpan.prototype = {
    "_ctor$0": function() {
        this._ticks = 0
    },
    "_ctor$1": function(a) {
        this._ctor$0();
        this._ticks = a
    },
    "_ctor$2": function(c, a, b) {
        this._ctor$0();
        this._ticks = c * AjaxControlToolkit.TimeSpan.TicksPerHour + a * AjaxControlToolkit.TimeSpan.TicksPerMinute + b * AjaxControlToolkit.TimeSpan.TicksPerSecond
    },
    "_ctor$3": function(d, c, a, b) {
        this._ctor$0();
        this._ticks = d * AjaxControlToolkit.TimeSpan.TicksPerDay + c * AjaxControlToolkit.TimeSpan.TicksPerHour + a * AjaxControlToolkit.TimeSpan.TicksPerMinute + b * AjaxControlToolkit.TimeSpan.TicksPerSecond
    },
    "_ctor$4": function(e, d, b, c, a) {
        this._ctor$0();
        this._ticks = e * AjaxControlToolkit.TimeSpan.TicksPerDay + d * AjaxControlToolkit.TimeSpan.TicksPerHour + b * AjaxControlToolkit.TimeSpan.TicksPerMinute + c * AjaxControlToolkit.TimeSpan.TicksPerSecond + a * AjaxControlToolkit.TimeSpan.TicksPerMillisecond
    },
    getDays: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerDay)
    },
    getHours: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerHour) % 24
    },
    getMinutes: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerMinute) % 60
    },
    getSeconds: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerSecond) % 60
    },
    getMilliseconds: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerMillisecond) % 1e3
    },
    getDuration: function() {
        return new AjaxControlToolkit.TimeSpan(Math.abs(this._ticks))
    },
    getTicks: function() {
        return this._ticks
    },
    getTotalDays: function() {
        Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerDay)
    },
    getTotalHours: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerHour)
    },
    getTotalMinutes: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerMinute)
    },
    getTotalSeconds: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerSecond)
    },
    getTotalMilliseconds: function() {
        return Math.floor(this._ticks / AjaxControlToolkit.TimeSpan.TicksPerMillisecond)
    },
    add: function(a) {
        return new AjaxControlToolkit.TimeSpan(this._ticks + a.getTicks())
    },
    subtract: function(a) {
        return new AjaxControlToolkit.TimeSpan(this._ticks - a.getTicks())
    },
    negate: function() {
        return new AjaxControlToolkit.TimeSpan(-this._ticks)
    },
    equals: function(a) {
        return this._ticks == a.getTicks()
    },
    compareTo: function(a) {
        if (this._ticks > a.getTicks())
            return 1;
        else if (this._ticks < a.getTicks())
            return -1;
        else
            return 0
    },
    toString: function() {
        return this.format("F")
    },
    format: function(a) {
        if (!a)
            a = "F";
        if (a.length == 1)
            switch (a) {
            case "t":
                a = AjaxControlToolkit.TimeSpan.ShortTimeSpanPattern;
                break;
            case "T":
                a = AjaxControlToolkit.TimeSpan.LongTimeSpanPattern;
                break;
            case "F":
                a = AjaxControlToolkit.TimeSpan.FullTimeSpanPattern;
                break;
            default:
                throw Error.createError(String.format(AjaxControlToolkit.Resources.Common_DateTime_InvalidTimeSpan, a));
            }
        var e = /dd|d|hh|h|mm|m|ss|s|nnnn|nnn|nn|n/g
          , c = new Sys.StringBuilder
          , d = this._ticks;
        if (d < 0) {
            c.append("-");
            d = -d
        }
        for (; true; ) {
            var f = e.lastIndex
              , b = e.exec(a);
            c.append(a.slice(f, b ? b.index : a.length));
            if (!b)
                break;
            switch (b[0]) {
            case "dd":
            case "d":
                c.append($common.padLeft(Math.floor(d / AjaxControlToolkit.TimeSpan.TicksPerDay, b[0].length, "0")));
                break;
            case "hh":
            case "h":
                c.append($common.padLeft(Math.floor(d / AjaxControlToolkit.TimeSpan.TicksPerHour) % 24, b[0].length, "0"));
                break;
            case "mm":
            case "m":
                c.append($common.padLeft(Math.floor(d / AjaxControlToolkit.TimeSpan.TicksPerMinute) % 60, b[0].length, "0"));
                break;
            case "ss":
            case "s":
                c.append($common.padLeft(Math.floor(d / AjaxControlToolkit.TimeSpan.TicksPerSecond) % 60, b[0].length, "0"));
                break;
            case "nnnn":
            case "nnn":
            case "nn":
            case "n":
                c.append($common.padRight(Math.floor(d / AjaxControlToolkit.TimeSpan.TicksPerMillisecond) % 1e3, b[0].length, "0", true));
                break;
            default:
                Sys.Debug.assert(false)
            }
        }
        return c.toString()
    }
};
AjaxControlToolkit.TimeSpan.parse = function(j) {
    var b = "."
      , a = j.split(":")
      , i = 0
      , f = 0
      , g = 0
      , d = 0
      , h = 0
      , e = 0;
    switch (a.length) {
    case 1:
        if (a[0].indexOf(b) != -1) {
            var c = a[0].split(b);
            d = parseInt(c[0]);
            h = parseInt(c[1])
        } else
            e = parseInt(a[0]);
        break;
    case 2:
        f = parseInt(a[0]);
        g = parseInt(a[1]);
        break;
    case 3:
        f = parseInt(a[0]);
        g = parseInt(a[1]);
        if (a[2].indexOf(b) != -1) {
            var c = a[2].split(b);
            d = parseInt(c[0]);
            h = parseInt(c[1])
        } else
            d = parseInt(a[2]);
        break;
    case 4:
        i = parseInt(a[0]);
        f = parseInt(a[1]);
        g = parseInt(a[2]);
        if (a[3].indexOf(b) != -1) {
            var c = a[3].split(b);
            d = parseInt(c[0]);
            h = parseInt(c[1])
        } else
            d = parseInt(a[3])
    }
    e += i * AjaxControlToolkit.TimeSpan.TicksPerDay + f * AjaxControlToolkit.TimeSpan.TicksPerHour + g * AjaxControlToolkit.TimeSpan.TicksPerMinute + d * AjaxControlToolkit.TimeSpan.TicksPerSecond + h * AjaxControlToolkit.TimeSpan.TicksPerMillisecond;
    if (!isNaN(e))
        return new AjaxControlToolkit.TimeSpan(e);
    throw Error.create(AjaxControlToolkit.Resources.Common_DateTime_InvalidFormat);
}
;
AjaxControlToolkit.TimeSpan.fromTicks = function(a) {
    return new AjaxControlToolkit.TimeSpan(a)
}
;
AjaxControlToolkit.TimeSpan.fromDays = function(a) {
    return new AjaxControlToolkit.TimeSpan(a * AjaxControlToolkit.TimeSpan.TicksPerDay)
}
;
AjaxControlToolkit.TimeSpan.fromHours = function(a) {
    return new AjaxControlToolkit.TimeSpan(a * AjaxControlToolkit.TimeSpan.TicksPerHour)
}
;
AjaxControlToolkit.TimeSpan.fromMinutes = function(a) {
    return new AjaxControlToolkit.TimeSpan(a * AjaxControlToolkit.TimeSpan.TicksPerMinute)
}
;
AjaxControlToolkit.TimeSpan.fromSeconds = function() {
    return new AjaxControlToolkit.TimeSpan(minutes * AjaxControlToolkit.TimeSpan.TicksPerSecond)
}
;
AjaxControlToolkit.TimeSpan.fromMilliseconds = function() {
    return new AjaxControlToolkit.TimeSpan(minutes * AjaxControlToolkit.TimeSpan.TicksPerMillisecond)
}
;
AjaxControlToolkit.TimeSpan.TicksPerDay = 8.64e11;
AjaxControlToolkit.TimeSpan.TicksPerHour = 3.6e10;
AjaxControlToolkit.TimeSpan.TicksPerMinute = 6e8;
AjaxControlToolkit.TimeSpan.TicksPerSecond = 1e7;
AjaxControlToolkit.TimeSpan.TicksPerMillisecond = 1e4;
AjaxControlToolkit.TimeSpan.FullTimeSpanPattern = "dd:hh:mm:ss.nnnn";
AjaxControlToolkit.TimeSpan.ShortTimeSpanPattern = "hh:mm";
AjaxControlToolkit.TimeSpan.LongTimeSpanPattern = "hh:mm:ss";
Date.prototype.getTimeOfDay = function() {
    var a = this;
    return new AjaxControlToolkit.TimeSpan(0,a.getHours(),a.getMinutes(),a.getSeconds(),a.getMilliseconds())
}
;
Date.prototype.getDateOnly = function() {
    return new Date(this.getFullYear(),this.getMonth(),this.getDate())
}
;
Date.prototype.add = function(a) {
    return new Date(this.getTime() + a.getTotalMilliseconds())
}
;
Date.prototype.subtract = function(a) {
    return this.add(a.negate())
}
;
Date.prototype.getTicks = function() {
    return this.getTime() * AjaxControlToolkit.TimeSpan.TicksPerMillisecond
}
;
AjaxControlToolkit.FirstDayOfWeek = function() {}
;
AjaxControlToolkit.FirstDayOfWeek.prototype = {
    Sunday: 0,
    Monday: 1,
    Tuesday: 2,
    Wednesday: 3,
    Thursday: 4,
    Friday: 5,
    Saturday: 6,
    Default: 7
};
AjaxControlToolkit.FirstDayOfWeek.registerEnum("AjaxControlToolkit.FirstDayOfWeek");
//END AjaxControlToolkit.Common.DateTime.js
//START AjaxControlToolkit.Compat.Timer.Timer.js
Sys.Timer = function() {
    var a = this;
    Sys.Timer.initializeBase(a);
    a._interval = 1e3;
    a._enabled = false;
    a._timer = null
}
;
Sys.Timer.prototype = {
    get_interval: function() {
        return this._interval
    },
    set_interval: function(b) {
        var a = this;
        if (a._interval !== b) {
            a._interval = b;
            a.raisePropertyChanged("interval");
            if (!a.get_isUpdating() && a._timer !== null) {
                a._stopTimer();
                a._startTimer()
            }
        }
    },
    get_enabled: function() {
        return this._enabled
    },
    set_enabled: function(b) {
        var a = this;
        if (b !== a.get_enabled()) {
            a._enabled = b;
            a.raisePropertyChanged("enabled");
            if (!a.get_isUpdating())
                if (b)
                    a._startTimer();
                else
                    a._stopTimer()
        }
    },
    add_tick: function(a) {
        this.get_events().addHandler("tick", a)
    },
    remove_tick: function(a) {
        this.get_events().removeHandler("tick", a)
    },
    dispose: function() {
        this.set_enabled(false);
        this._stopTimer();
        Sys.Timer.callBaseMethod(this, "dispose")
    },
    updated: function() {
        var a = this;
        Sys.Timer.callBaseMethod(a, "updated");
        if (a._enabled) {
            a._stopTimer();
            a._startTimer()
        }
    },
    _timerCallback: function() {
        var a = this.get_events().getHandler("tick");
        a && a(this, Sys.EventArgs.Empty)
    },
    _startTimer: function() {
        var a = this;
        a._timer = window.setInterval(Function.createDelegate(a, a._timerCallback), a._interval)
    },
    _stopTimer: function() {
        window.clearInterval(this._timer);
        this._timer = null
    }
};
Sys.Timer.descriptor = {
    properties: [{
        name: "interval",
        type: Number
    }, {
        name: "enabled",
        type: Boolean
    }],
    events: [{
        name: "tick"
    }]
};
Sys.Timer.registerClass("Sys.Timer", Sys.Component);
//END AjaxControlToolkit.Compat.Timer.Timer.js
//START AjaxControlToolkit.Animation.Animations.js
Type.registerNamespace("AjaxControlToolkit.Animation");
var $AA = AjaxControlToolkit.Animation;
$AA.registerAnimation = function(b, a) {
    if (a && (a === $AA.Animation || a.inheritsFrom && a.inheritsFrom($AA.Animation))) {
        if (!$AA.__animations)
            $AA.__animations = {};
        $AA.__animations[b.toLowerCase()] = a;
        a.play = function() {
            var b = new a;
            a.apply(b, arguments);
            b.initialize();
            var c = Function.createDelegate(b, function() {
                b.remove_ended(c);
                c = null;
                b.dispose()
            });
            b.add_ended(c);
            b.play()
        }
    } else
        throw Error.argumentType("type", a, $AA.Animation, AjaxControlToolkit.Resources.Animation_InvalidBaseType);
}
;
$AA.buildAnimation = function(a, c) {
    if (!a || a === "")
        return null;
    var b;
    a = "(" + a + ")";
    if (!Sys.Debug.isDebug)
        try {
            b = Sys.Serialization.JavaScriptSerializer.deserialize(a)
        } catch (d) {}
    else
        b = Sys.Serialization.JavaScriptSerializer.deserialize(a);
    return $AA.createAnimation(b, c)
}
;
$AA.createAnimation = function(c, l) {
    var g = "obj";
    if (!c || !c.AnimationName)
        throw Error.argument(g, AjaxControlToolkit.Resources.Animation_MissingAnimationName);
    var b = $AA.__animations[c.AnimationName.toLowerCase()];
    if (!b)
        throw Error.argument("type", String.format(AjaxControlToolkit.Resources.Animation_UknownAnimationName, c.AnimationName));
    var d = new b;
    l && d.set_target(l);
    if (c.AnimationChildren && c.AnimationChildren.length)
        if ($AA.ParentAnimation.isInstanceOfType(d))
            for (var k = 0; k < c.AnimationChildren.length; k++) {
                var m = $AA.createAnimation(c.AnimationChildren[k]);
                m && d.add(m)
            }
        else
            throw Error.argument(g, String.format(AjaxControlToolkit.Resources.Animation_ChildrenNotAllowed, b.getName()));
    var h = b.__animationProperties;
    if (!h) {
        b.__animationProperties = {};
        b.resolveInheritance();
        for (var j in b.prototype)
            if (j.startsWith("set_"))
                b.__animationProperties[j.substr(4).toLowerCase()] = j;
        delete b.__animationProperties["id"];
        h = b.__animationProperties
    }
    for (var e in c) {
        var f = e.toLowerCase();
        if (f == "animationname" || f == "animationchildren")
            continue;
        var i = c[e]
          , a = h[f];
        if (a && String.isInstanceOfType(a) && d[a])
            if (!Sys.Debug.isDebug)
                try {
                    d[a](i)
                } catch (n) {}
            else
                d[a](i);
        else if (f.endsWith("script")) {
            a = h[f.substr(0, e.length - 6)];
            if (a && String.isInstanceOfType(a) && d[a])
                d.DynamicProperties[a] = i;
            else if (Sys.Debug.isDebug)
                throw Error.argument(g, String.format(AjaxControlToolkit.Resources.Animation_NoDynamicPropertyFound, e, e.substr(0, e.length - 5)));
        } else if (Sys.Debug.isDebug)
            throw Error.argument(g, String.format(AjaxControlToolkit.Resources.Animation_NoPropertyFound, e));
    }
    return d
}
;
$AA.Animation = function(d, c, e) {
    var b = null
      , a = this;
    $AA.Animation.initializeBase(a);
    a._duration = 1;
    a._fps = 25;
    a._target = b;
    a._tickHandler = b;
    a._timer = b;
    a._percentComplete = 0;
    a._percentDelta = b;
    a._owner = b;
    a._parentAnimation = b;
    a.DynamicProperties = {};
    d && a.set_target(d);
    c && a.set_duration(c);
    e && a.set_fps(e)
}
;
$AA.Animation.prototype = {
    dispose: function() {
        var a = this;
        if (a._timer) {
            a._timer.dispose();
            a._timer = null
        }
        a._tickHandler = null;
        a._target = null;
        $AA.Animation.callBaseMethod(a, "dispose")
    },
    play: function() {
        var a = this;
        if (!a._owner) {
            var b = true;
            if (!a._timer) {
                b = false;
                if (!a._tickHandler)
                    a._tickHandler = Function.createDelegate(a, a._onTimerTick);
                a._timer = new Sys.Timer;
                a._timer.add_tick(a._tickHandler);
                a.onStart();
                a._timer.set_interval(1e3 / a._fps);
                a._percentDelta = 100 / (a._duration * a._fps);
                a._updatePercentComplete(0, true)
            }
            a._timer.set_enabled(true);
            a.raisePropertyChanged("isPlaying");
            !b && a.raisePropertyChanged("isActive")
        }
    },
    pause: function() {
        var a = this;
        if (!a._owner)
            if (a._timer) {
                a._timer.set_enabled(false);
                a.raisePropertyChanged("isPlaying")
            }
    },
    stop: function(b) {
        var a = this;
        if (!a._owner) {
            var c = a._timer;
            a._timer = null;
            if (c) {
                c.dispose();
                if (a._percentComplete !== 100) {
                    a._percentComplete = 100;
                    a.raisePropertyChanged("percentComplete");
                    (b || b === undefined) && a.onStep(100)
                }
                a.onEnd();
                a.raisePropertyChanged("isPlaying");
                a.raisePropertyChanged("isActive")
            }
        }
    },
    onStart: function() {
        var a = this;
        a.raiseStarted();
        for (var property in a.DynamicProperties)
            try {
                a[property](eval(a.DynamicProperties[property]))
            } catch (a) {
                if (Sys.Debug.isDebug)
                    throw a;
            }
    },
    onStep: function(a) {
        this.setValue(this.getAnimatedValue(a));
        this.raiseStep()
    },
    onEnd: function() {
        this.raiseEnded()
    },
    getAnimatedValue: function() {
        throw Error.notImplemented();
    },
    setValue: function() {
        throw Error.notImplemented();
    },
    interpolate: function(a, c, b) {
        return a + (c - a) * (b / 100)
    },
    _onTimerTick: function() {
        this._updatePercentComplete(this._percentComplete + this._percentDelta, true)
    },
    _updatePercentComplete: function(a, c) {
        var b = this;
        if (a > 100)
            a = 100;
        b._percentComplete = a;
        b.raisePropertyChanged("percentComplete");
        c && b.onStep(a);
        a === 100 && b.stop(false)
    },
    setOwner: function(a) {
        this._owner = a
    },
    raiseStarted: function() {
        var a = this.get_events().getHandler("started");
        a && a(this, Sys.EventArgs.Empty)
    },
    add_started: function(a) {
        this.get_events().addHandler("started", a)
    },
    remove_started: function(a) {
        this.get_events().removeHandler("started", a)
    },
    raiseEnded: function() {
        var a = this.get_events().getHandler("ended");
        a && a(this, Sys.EventArgs.Empty)
    },
    add_ended: function(a) {
        this.get_events().addHandler("ended", a)
    },
    remove_ended: function(a) {
        this.get_events().removeHandler("ended", a)
    },
    raiseStep: function() {
        var a = this.get_events().getHandler("step");
        a && a(this, Sys.EventArgs.Empty)
    },
    add_step: function(a) {
        this.get_events().addHandler("step", a)
    },
    remove_step: function(a) {
        this.get_events().removeHandler("step", a)
    },
    get_target: function() {
        var a = this;
        if (!a._target && a._parentAnimation)
            return a._parentAnimation.get_target();
        return a._target
    },
    set_target: function(a) {
        if (this._target != a) {
            this._target = a;
            this.raisePropertyChanged("target")
        }
    },
    set_animationTarget: function(c) {
        var b = null
          , a = $get(c);
        if (a)
            b = a;
        else {
            var d = $find(c);
            if (d) {
                a = d.get_element();
                if (a)
                    b = a
            }
        }
        if (b)
            this.set_target(b);
        else
            throw Error.argument("id", String.format(AjaxControlToolkit.Resources.Animation_TargetNotFound, c));
    },
    get_duration: function() {
        return this._duration
    },
    set_duration: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._duration != b) {
            a._duration = b;
            a.raisePropertyChanged("duration")
        }
    },
    get_fps: function() {
        return this._fps
    },
    set_fps: function(b) {
        var a = this;
        b = a._getInteger(b);
        if (a.fps != b) {
            a._fps = b;
            a.raisePropertyChanged("fps")
        }
    },
    get_isActive: function() {
        return this._timer !== null
    },
    get_isPlaying: function() {
        return this._timer !== null && this._timer.get_enabled()
    },
    get_percentComplete: function() {
        return this._percentComplete
    },
    _getBoolean: function(a) {
        if (String.isInstanceOfType(a))
            return Boolean.parse(a);
        return a
    },
    _getInteger: function(a) {
        if (String.isInstanceOfType(a))
            return parseInt(a);
        return a
    },
    _getFloat: function(a) {
        if (String.isInstanceOfType(a))
            return parseFloat(a);
        return a
    },
    _getEnum: function(a, b) {
        if (String.isInstanceOfType(a) && b && b.parse)
            return b.parse(a);
        return a
    }
};
$AA.Animation.registerClass("AjaxControlToolkit.Animation.Animation", Sys.Component);
$AA.registerAnimation("animation", $AA.Animation);
$AA.ParentAnimation = function(d, c, e, a) {
    $AA.ParentAnimation.initializeBase(this, [d, c, e]);
    this._animations = [];
    if (a && a.length)
        for (var b = 0; b < a.length; b++)
            this.add(a[b])
}
;
$AA.ParentAnimation.prototype = {
    initialize: function() {
        var a = this;
        $AA.ParentAnimation.callBaseMethod(a, "initialize");
        if (a._animations)
            for (var c = 0; c < a._animations.length; c++) {
                var b = a._animations[c];
                b && !b.get_isInitialized && b.initialize()
            }
    },
    dispose: function() {
        this.clear();
        this._animations = null;
        $AA.ParentAnimation.callBaseMethod(this, "dispose")
    },
    get_animations: function() {
        return this._animations
    },
    add: function(b) {
        var a = this;
        if (a._animations) {
            if (b)
                b._parentAnimation = a;
            Array.add(a._animations, b);
            a.raisePropertyChanged("animations")
        }
    },
    remove: function(a) {
        if (this._animations) {
            a && a.dispose();
            Array.remove(this._animations, a);
            this.raisePropertyChanged("animations")
        }
    },
    removeAt: function(c) {
        var a = this;
        if (a._animations) {
            var b = a._animations[c];
            b && b.dispose();
            Array.removeAt(a._animations, c);
            a.raisePropertyChanged("animations")
        }
    },
    clear: function() {
        var a = this;
        if (a._animations) {
            for (var b = a._animations.length - 1; b >= 0; b--) {
                a._animations[b].dispose();
                a._animations[b] = null
            }
            Array.clear(a._animations);
            a._animations = [];
            a.raisePropertyChanged("animations")
        }
    }
};
$AA.ParentAnimation.registerClass("AjaxControlToolkit.Animation.ParentAnimation", $AA.Animation);
$AA.registerAnimation("parent", $AA.ParentAnimation);
$AA.ParallelAnimation = function(c, b, d, a) {
    $AA.ParallelAnimation.initializeBase(this, [c, b, d, a])
}
;
$AA.ParallelAnimation.prototype = {
    add: function(a) {
        $AA.ParallelAnimation.callBaseMethod(this, "add", [a]);
        a.setOwner(this)
    },
    onStart: function() {
        $AA.ParallelAnimation.callBaseMethod(this, "onStart");
        for (var b = this.get_animations(), a = 0; a < b.length; a++)
            b[a].onStart()
    },
    onStep: function(c) {
        for (var b = this.get_animations(), a = 0; a < b.length; a++)
            b[a].onStep(c)
    },
    onEnd: function() {
        for (var b = this.get_animations(), a = 0; a < b.length; a++)
            b[a].onEnd();
        $AA.ParallelAnimation.callBaseMethod(this, "onEnd")
    }
};
$AA.ParallelAnimation.registerClass("AjaxControlToolkit.Animation.ParallelAnimation", $AA.ParentAnimation);
$AA.registerAnimation("parallel", $AA.ParallelAnimation);
$AA.SequenceAnimation = function(e, d, f, c, b) {
    var a = this;
    $AA.SequenceAnimation.initializeBase(a, [e, d, f, c]);
    a._handler = null;
    a._paused = false;
    a._playing = false;
    a._index = 0;
    a._remainingIterations = 0;
    a._iterations = b !== undefined ? b : 1
}
;
$AA.SequenceAnimation.prototype = {
    dispose: function() {
        this._handler = null;
        $AA.SequenceAnimation.callBaseMethod(this, "dispose")
    },
    stop: function() {
        var a = this;
        if (a._playing) {
            var b = a.get_animations();
            if (a._index < b.length) {
                b[a._index].remove_ended(a._handler);
                for (var c = a._index; c < b.length; c++)
                    b[c].stop()
            }
            a._playing = false;
            a._paused = false;
            a.raisePropertyChanged("isPlaying");
            a.onEnd()
        }
    },
    pause: function() {
        var a = this;
        if (a.get_isPlaying()) {
            var b = a.get_animations()[a._index];
            b != null && b.pause();
            a._paused = true;
            a.raisePropertyChanged("isPlaying")
        }
    },
    play: function() {
        var c = "isPlaying"
          , a = this
          , d = a.get_animations();
        if (!a._playing) {
            a._playing = true;
            if (a._paused) {
                a._paused = false;
                var e = d[a._index];
                if (e != null) {
                    e.play();
                    a.raisePropertyChanged(c)
                }
            } else {
                a.onStart();
                a._index = 0;
                var b = d[a._index];
                if (b) {
                    b.add_ended(a._handler);
                    b.play();
                    a.raisePropertyChanged(c)
                } else
                    a.stop()
            }
        }
    },
    onStart: function() {
        var a = this;
        $AA.SequenceAnimation.callBaseMethod(a, "onStart");
        a._remainingIterations = a._iterations - 1;
        if (!a._handler)
            a._handler = Function.createDelegate(a, a._onEndAnimation)
    },
    _onEndAnimation: function() {
        var a = this
          , b = a.get_animations()
          , c = b[a._index++];
        c && c.remove_ended(a._handler);
        if (a._index < b.length) {
            var e = b[a._index];
            e.add_ended(a._handler);
            e.play()
        } else if (a._remainingIterations >= 1 || a._iterations <= 0) {
            a._remainingIterations--;
            a._index = 0;
            var d = b[0];
            d.add_ended(a._handler);
            d.play()
        } else
            a.stop()
    },
    onStep: function() {
        throw Error.invalidOperation(AjaxControlToolkit.Resources.Animation_CannotNestSequence);
    },
    onEnd: function() {
        this._remainingIterations = 0;
        $AA.SequenceAnimation.callBaseMethod(this, "onEnd")
    },
    get_isActive: function() {
        return true
    },
    get_isPlaying: function() {
        return this._playing && !this._paused
    },
    get_iterations: function() {
        return this._iterations
    },
    set_iterations: function(b) {
        var a = this;
        b = a._getInteger(b);
        if (a._iterations != b) {
            a._iterations = b;
            a.raisePropertyChanged("iterations")
        }
    },
    get_isInfinite: function() {
        return this._iterations <= 0
    }
};
$AA.SequenceAnimation.registerClass("AjaxControlToolkit.Animation.SequenceAnimation", $AA.ParentAnimation);
$AA.registerAnimation("sequence", $AA.SequenceAnimation);
$AA.SelectionAnimation = function(c, b, d, a) {
    $AA.SelectionAnimation.initializeBase(this, [c, b, d, a]);
    this._selectedIndex = -1;
    this._selected = null
}
;
$AA.SelectionAnimation.prototype = {
    getSelectedIndex: function() {
        throw Error.notImplemented();
    },
    onStart: function() {
        var a = this;
        $AA.SelectionAnimation.callBaseMethod(a, "onStart");
        var b = a.get_animations();
        a._selectedIndex = a.getSelectedIndex();
        if (a._selectedIndex >= 0 && a._selectedIndex < b.length) {
            a._selected = b[a._selectedIndex];
            if (a._selected) {
                a._selected.setOwner(a);
                a._selected.onStart()
            }
        }
    },
    onStep: function(a) {
        this._selected && this._selected.onStep(a)
    },
    onEnd: function() {
        var a = this;
        if (a._selected) {
            a._selected.onEnd();
            a._selected.setOwner(null)
        }
        a._selected = null;
        a._selectedIndex = null;
        $AA.SelectionAnimation.callBaseMethod(a, "onEnd")
    }
};
$AA.SelectionAnimation.registerClass("AjaxControlToolkit.Animation.SelectionAnimation", $AA.ParentAnimation);
$AA.registerAnimation("selection", $AA.SelectionAnimation);
$AA.ConditionAnimation = function(d, c, e, b, a) {
    $AA.ConditionAnimation.initializeBase(this, [d, c, e, b]);
    this._conditionScript = a
}
;
$AA.ConditionAnimation.prototype = {
    getSelectedIndex: function() {
        var selected = -1;
        if (this._conditionScript && this._conditionScript.length > 0)
            try {
                selected = eval(this._conditionScript) ? 0 : 1
            } catch (a) {}
        return selected
    },
    get_conditionScript: function() {
        return this._conditionScript
    },
    set_conditionScript: function(a) {
        if (this._conditionScript != a) {
            this._conditionScript = a;
            this.raisePropertyChanged("conditionScript")
        }
    }
};
$AA.ConditionAnimation.registerClass("AjaxControlToolkit.Animation.ConditionAnimation", $AA.SelectionAnimation);
$AA.registerAnimation("condition", $AA.ConditionAnimation);
$AA.CaseAnimation = function(d, c, e, b, a) {
    $AA.CaseAnimation.initializeBase(this, [d, c, e, b]);
    this._selectScript = a
}
;
$AA.CaseAnimation.prototype = {
    getSelectedIndex: function() {
        var selected = -1;
        if (this._selectScript && this._selectScript.length > 0)
            try {
                var result = eval(this._selectScript);
                if (result !== undefined)
                    selected = result
            } catch (a) {}
        return selected
    },
    get_selectScript: function() {
        return this._selectScript
    },
    set_selectScript: function(a) {
        if (this._selectScript != a) {
            this._selectScript = a;
            this.raisePropertyChanged("selectScript")
        }
    }
};
$AA.CaseAnimation.registerClass("AjaxControlToolkit.Animation.CaseAnimation", $AA.SelectionAnimation);
$AA.registerAnimation("case", $AA.CaseAnimation);
$AA.FadeEffect = function() {
    throw Error.invalidOperation();
}
;
$AA.FadeEffect.prototype = {
    FadeIn: 0,
    FadeOut: 1
};
$AA.FadeEffect.registerEnum("AjaxControlToolkit.Animation.FadeEffect", false);
$AA.FadeAnimation = function(g, f, h, e, d, c, b) {
    var a = this;
    $AA.FadeAnimation.initializeBase(a, [g, f, h]);
    a._effect = e !== undefined ? e : $AA.FadeEffect.FadeIn;
    a._max = c !== undefined ? c : 1;
    a._min = d !== undefined ? d : 0;
    a._start = a._min;
    a._end = a._max;
    a._layoutCreated = false;
    a._forceLayoutInIE = b === undefined || b === null ? true : b;
    a._currentTarget = null;
    a._resetOpacities()
}
;
$AA.FadeAnimation.prototype = {
    _resetOpacities: function() {
        var a = this;
        if (a._effect == $AA.FadeEffect.FadeIn) {
            a._start = a._min;
            a._end = a._max
        } else {
            a._start = a._max;
            a._end = a._min
        }
    },
    _createLayout: function() {
        var a = this
          , b = a._currentTarget;
        if (b) {
            a._originalWidth = $common.getCurrentStyle(b, "width");
            var c = $common.getCurrentStyle(b, "height");
            a._originalBackColor = $common.getCurrentStyle(b, "backgroundColor");
            if ((!a._originalWidth || a._originalWidth == "" || a._originalWidth == "auto") && (!c || c == "" || c == "auto"))
                b.style.width = b.offsetWidth + "px";
            if (!a._originalBackColor || a._originalBackColor == "" || a._originalBackColor == "transparent" || a._originalBackColor == "rgba(0, 0, 0, 0)")
                b.style.backgroundColor = $common.getInheritedBackgroundColor(b);
            a._layoutCreated = true
        }
    },
    onStart: function() {
        var a = this;
        $AA.FadeAnimation.callBaseMethod(a, "onStart");
        a._currentTarget = a.get_target();
        a.setValue(a._start);
        a._forceLayoutInIE && !a._layoutCreated && Sys.Browser.agent == Sys.Browser.InternetExplorer && a._createLayout()
    },
    getAnimatedValue: function(a) {
        return this.interpolate(this._start, this._end, a)
    },
    setValue: function(a) {
        this._currentTarget && $common.setElementOpacity(this._currentTarget, a)
    },
    get_effect: function() {
        return this._effect
    },
    set_effect: function(b) {
        var a = this;
        b = a._getEnum(b, $AA.FadeEffect);
        if (a._effect != b) {
            a._effect = b;
            a._resetOpacities();
            a.raisePropertyChanged("effect")
        }
    },
    get_minimumOpacity: function() {
        return this._min
    },
    set_minimumOpacity: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._min != b) {
            a._min = b;
            a._resetOpacities();
            a.raisePropertyChanged("minimumOpacity")
        }
    },
    get_maximumOpacity: function() {
        return this._max
    },
    set_maximumOpacity: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._max != b) {
            a._max = b;
            a._resetOpacities();
            a.raisePropertyChanged("maximumOpacity")
        }
    },
    get_forceLayoutInIE: function() {
        return this._forceLayoutInIE
    },
    set_forceLayoutInIE: function(b) {
        var a = this;
        b = a._getBoolean(b);
        if (a._forceLayoutInIE != b) {
            a._forceLayoutInIE = b;
            a.raisePropertyChanged("forceLayoutInIE")
        }
    },
    set_startValue: function(a) {
        a = this._getFloat(a);
        this._start = a
    }
};
$AA.FadeAnimation.registerClass("AjaxControlToolkit.Animation.FadeAnimation", $AA.Animation);
$AA.registerAnimation("fade", $AA.FadeAnimation);
$AA.FadeInAnimation = function(e, d, f, c, b, a) {
    $AA.FadeInAnimation.initializeBase(this, [e, d, f, $AA.FadeEffect.FadeIn, c, b, a])
}
;
$AA.FadeInAnimation.prototype = {
    onStart: function() {
        var a = this;
        $AA.FadeInAnimation.callBaseMethod(a, "onStart");
        a._currentTarget && a.set_startValue($common.getElementOpacity(a._currentTarget))
    }
};
$AA.FadeInAnimation.registerClass("AjaxControlToolkit.Animation.FadeInAnimation", $AA.FadeAnimation);
$AA.registerAnimation("fadeIn", $AA.FadeInAnimation);
$AA.FadeOutAnimation = function(e, d, f, c, b, a) {
    $AA.FadeOutAnimation.initializeBase(this, [e, d, f, $AA.FadeEffect.FadeOut, c, b, a])
}
;
$AA.FadeOutAnimation.prototype = {
    onStart: function() {
        var a = this;
        $AA.FadeOutAnimation.callBaseMethod(a, "onStart");
        a._currentTarget && a.set_startValue($common.getElementOpacity(a._currentTarget))
    }
};
$AA.FadeOutAnimation.registerClass("AjaxControlToolkit.Animation.FadeOutAnimation", $AA.FadeAnimation);
$AA.registerAnimation("fadeOut", $AA.FadeOutAnimation);
$AA.PulseAnimation = function(c, b, d, h, g, f, e) {
    var a = this;
    $AA.PulseAnimation.initializeBase(a, [c, b, d, null, h !== undefined ? h : 3]);
    a._out = new $AA.FadeOutAnimation(c,b,d,g,f,e);
    a.add(a._out);
    a._in = new $AA.FadeInAnimation(c,b,d,g,f,e);
    a.add(a._in)
}
;
$AA.PulseAnimation.prototype = {
    get_minimumOpacity: function() {
        return this._out.get_minimumOpacity()
    },
    set_minimumOpacity: function(b) {
        var a = this;
        b = a._getFloat(b);
        a._out.set_minimumOpacity(b);
        a._in.set_minimumOpacity(b);
        a.raisePropertyChanged("minimumOpacity")
    },
    get_maximumOpacity: function() {
        return this._out.get_maximumOpacity()
    },
    set_maximumOpacity: function(b) {
        var a = this;
        b = a._getFloat(b);
        a._out.set_maximumOpacity(b);
        a._in.set_maximumOpacity(b);
        a.raisePropertyChanged("maximumOpacity")
    },
    get_forceLayoutInIE: function() {
        return this._out.get_forceLayoutInIE()
    },
    set_forceLayoutInIE: function(b) {
        var a = this;
        b = a._getBoolean(b);
        a._out.set_forceLayoutInIE(b);
        a._in.set_forceLayoutInIE(b);
        a.raisePropertyChanged("forceLayoutInIE")
    },
    set_duration: function(a) {
        var b = this;
        a = b._getFloat(a);
        $AA.PulseAnimation.callBaseMethod(b, "set_duration", [a]);
        b._in.set_duration(a);
        b._out.set_duration(a)
    },
    set_fps: function(a) {
        var b = this;
        a = b._getInteger(a);
        $AA.PulseAnimation.callBaseMethod(b, "set_fps", [a]);
        b._in.set_fps(a);
        b._out.set_fps(a)
    }
};
$AA.PulseAnimation.registerClass("AjaxControlToolkit.Animation.PulseAnimation", $AA.SequenceAnimation);
$AA.registerAnimation("pulse", $AA.PulseAnimation);
$AA.PropertyAnimation = function(e, c, f, d, b) {
    var a = this;
    $AA.PropertyAnimation.initializeBase(a, [e, c, f]);
    a._property = d;
    a._propertyKey = b;
    a._currentTarget = null
}
;
$AA.PropertyAnimation.prototype = {
    onStart: function() {
        $AA.PropertyAnimation.callBaseMethod(this, "onStart");
        this._currentTarget = this.get_target()
    },
    setValue: function(c) {
        var a = this
          , b = a._currentTarget;
        if (b && a._property && a._property.length > 0)
            if (a._propertyKey && a._propertyKey.length > 0 && b[a._property])
                b[a._property][a._propertyKey] = c;
            else
                b[a._property] = c
    },
    getValue: function() {
        var a = this
          , c = a.get_target();
        if (c && a._property && a._property.length > 0) {
            var b = c[a._property];
            if (b) {
                if (a._propertyKey && a._propertyKey.length > 0)
                    return b[a._propertyKey];
                return b
            }
        }
        return null
    },
    get_property: function() {
        return this._property
    },
    set_property: function(a) {
        if (this._property != a) {
            this._property = a;
            this.raisePropertyChanged("property")
        }
    },
    get_propertyKey: function() {
        return this._propertyKey
    },
    set_propertyKey: function(a) {
        if (this._propertyKey != a) {
            this._propertyKey = a;
            this.raisePropertyChanged("propertyKey")
        }
    }
};
$AA.PropertyAnimation.registerClass("AjaxControlToolkit.Animation.PropertyAnimation", $AA.Animation);
$AA.registerAnimation("property", $AA.PropertyAnimation);
$AA.DiscreteAnimation = function(e, c, f, d, b, a) {
    $AA.DiscreteAnimation.initializeBase(this, [e, c, f, d, b]);
    this._values = a && a.length ? a : []
}
;
$AA.DiscreteAnimation.prototype = {
    getAnimatedValue: function(a) {
        var b = Math.floor(this.interpolate(0, this._values.length - 1, a));
        return this._values[b]
    },
    get_values: function() {
        return this._values
    },
    set_values: function(a) {
        if (this._values != a) {
            this._values = a;
            this.raisePropertyChanged("values")
        }
    }
};
$AA.DiscreteAnimation.registerClass("AjaxControlToolkit.Animation.DiscreteAnimation", $AA.PropertyAnimation);
$AA.registerAnimation("discrete", $AA.DiscreteAnimation);
$AA.InterpolatedAnimation = function(f, d, g, a, b, c, e) {
    $AA.InterpolatedAnimation.initializeBase(this, [f, d, g, a !== undefined ? a : "style", b]);
    this._startValue = c;
    this._endValue = e
}
;
$AA.InterpolatedAnimation.prototype = {
    get_startValue: function() {
        return this._startValue
    },
    set_startValue: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._startValue != b) {
            a._startValue = b;
            a.raisePropertyChanged("startValue")
        }
    },
    get_endValue: function() {
        return this._endValue
    },
    set_endValue: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._endValue != b) {
            a._endValue = b;
            a.raisePropertyChanged("endValue")
        }
    }
};
$AA.InterpolatedAnimation.registerClass("AjaxControlToolkit.Animation.InterpolatedAnimation", $AA.PropertyAnimation);
$AA.registerAnimation("interpolated", $AA.InterpolatedAnimation);
$AA.ColorAnimation = function(g, d, h, f, b, c, e) {
    var a = this;
    $AA.ColorAnimation.initializeBase(a, [g, d, h, f, b, c, e]);
    a._start = null;
    a._end = null;
    a._interpolateRed = false;
    a._interpolateGreen = false;
    a._interpolateBlue = false
}
;
$AA.ColorAnimation.prototype = {
    onStart: function() {
        var a = this;
        $AA.ColorAnimation.callBaseMethod(a, "onStart");
        a._start = $AA.ColorAnimation.getRGB(a.get_startValue());
        a._end = $AA.ColorAnimation.getRGB(a.get_endValue());
        a._interpolateRed = a._start.Red != a._end.Red;
        a._interpolateGreen = a._start.Green != a._end.Green;
        a._interpolateBlue = a._start.Blue != a._end.Blue
    },
    getAnimatedValue: function(b) {
        var a = this
          , e = a._start.Red
          , d = a._start.Green
          , c = a._start.Blue;
        if (a._interpolateRed)
            e = Math.round(a.interpolate(e, a._end.Red, b));
        if (a._interpolateGreen)
            d = Math.round(a.interpolate(d, a._end.Green, b));
        if (a._interpolateBlue)
            c = Math.round(a.interpolate(c, a._end.Blue, b));
        return $AA.ColorAnimation.toColor(e, d, c)
    },
    set_startValue: function(a) {
        if (this._startValue != a) {
            this._startValue = a;
            this.raisePropertyChanged("startValue")
        }
    },
    set_endValue: function(a) {
        if (this._endValue != a) {
            this._endValue = a;
            this.raisePropertyChanged("endValue")
        }
    }
};
$AA.ColorAnimation.getRGB = function(a) {
    if (!a || a.length != 7)
        throw String.format(AjaxControlToolkit.Resources.Animation_InvalidColor, a);
    return {
        Red: parseInt(a.substr(1, 2), 16),
        Green: parseInt(a.substr(3, 2), 16),
        Blue: parseInt(a.substr(5, 2), 16)
    }
}
;
$AA.ColorAnimation.toColor = function(f, d, e) {
    var c = f.toString(16)
      , b = d.toString(16)
      , a = e.toString(16);
    if (c.length == 1)
        c = "0" + c;
    if (b.length == 1)
        b = "0" + b;
    if (a.length == 1)
        a = "0" + a;
    return "#" + c + b + a
}
;
$AA.ColorAnimation.registerClass("AjaxControlToolkit.Animation.ColorAnimation", $AA.InterpolatedAnimation);
$AA.registerAnimation("color", $AA.ColorAnimation);
$AA.LengthAnimation = function(g, d, h, f, b, c, e, a) {
    $AA.LengthAnimation.initializeBase(this, [g, d, h, f, b, c, e]);
    this._unit = a != null ? a : "px"
}
;
$AA.LengthAnimation.prototype = {
    getAnimatedValue: function(b) {
        var a = this
          , c = a.interpolate(a.get_startValue(), a.get_endValue(), b);
        return Math.round(c) + a._unit
    },
    get_unit: function() {
        return this._unit
    },
    set_unit: function(a) {
        if (this._unit != a) {
            this._unit = a;
            this.raisePropertyChanged("unit")
        }
    }
};
$AA.LengthAnimation.registerClass("AjaxControlToolkit.Animation.LengthAnimation", $AA.InterpolatedAnimation);
$AA.registerAnimation("length", $AA.LengthAnimation);
$AA.MoveAnimation = function(d, c, e, f, h, g, i) {
    var b = null
      , a = this;
    $AA.MoveAnimation.initializeBase(a, [d, c, e, b]);
    a._horizontal = f ? f : 0;
    a._vertical = h ? h : 0;
    a._relative = g === undefined ? true : g;
    a._horizontalAnimation = new $AA.LengthAnimation(d,c,e,"style","left",b,b,i);
    a._verticalAnimation = new $AA.LengthAnimation(d,c,e,"style","top",b,b,i);
    a.add(a._verticalAnimation);
    a.add(a._horizontalAnimation)
}
;
$AA.MoveAnimation.prototype = {
    onStart: function() {
        var a = this;
        $AA.MoveAnimation.callBaseMethod(a, "onStart");
        var b = a.get_target();
        a._horizontalAnimation.set_startValue(b.offsetLeft);
        a._horizontalAnimation.set_endValue(a._relative ? b.offsetLeft + a._horizontal : a._horizontal);
        a._verticalAnimation.set_startValue(b.offsetTop);
        a._verticalAnimation.set_endValue(a._relative ? b.offsetTop + a._vertical : a._vertical)
    },
    get_horizontal: function() {
        return this._horizontal
    },
    set_horizontal: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._horizontal != b) {
            a._horizontal = b;
            a.raisePropertyChanged("horizontal")
        }
    },
    get_vertical: function() {
        return this._vertical
    },
    set_vertical: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._vertical != b) {
            a._vertical = b;
            a.raisePropertyChanged("vertical")
        }
    },
    get_relative: function() {
        return this._relative
    },
    set_relative: function(b) {
        var a = this;
        b = a._getBoolean(b);
        if (a._relative != b) {
            a._relative = b;
            a.raisePropertyChanged("relative")
        }
    },
    get_unit: function() {
        this._horizontalAnimation.get_unit()
    },
    set_unit: function(b) {
        var a = this
          , c = a._horizontalAnimation.get_unit();
        if (c != b) {
            a._horizontalAnimation.set_unit(b);
            a._verticalAnimation.set_unit(b);
            a.raisePropertyChanged("unit")
        }
    }
};
$AA.MoveAnimation.registerClass("AjaxControlToolkit.Animation.MoveAnimation", $AA.ParallelAnimation);
$AA.registerAnimation("move", $AA.MoveAnimation);
$AA.ResizeAnimation = function(d, c, e, h, g, f) {
    var b = null
      , a = this;
    $AA.ResizeAnimation.initializeBase(a, [d, c, e, b]);
    a._width = h;
    a._height = g;
    a._horizontalAnimation = new $AA.LengthAnimation(d,c,e,"style","width",b,b,f);
    a._verticalAnimation = new $AA.LengthAnimation(d,c,e,"style","height",b,b,f);
    a.add(a._horizontalAnimation);
    a.add(a._verticalAnimation)
}
;
$AA.ResizeAnimation.prototype = {
    onStart: function() {
        var a = this;
        $AA.ResizeAnimation.callBaseMethod(a, "onStart");
        var b = a.get_target();
        a._horizontalAnimation.set_startValue(b.offsetWidth);
        a._verticalAnimation.set_startValue(b.offsetHeight);
        a._horizontalAnimation.set_endValue(a._width !== null && a._width !== undefined ? a._width : b.offsetWidth);
        a._verticalAnimation.set_endValue(a._height !== null && a._height !== undefined ? a._height : b.offsetHeight)
    },
    get_width: function() {
        return this._width
    },
    set_width: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._width != b) {
            a._width = b;
            a.raisePropertyChanged("width")
        }
    },
    get_height: function() {
        return this._height
    },
    set_height: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._height != b) {
            a._height = b;
            a.raisePropertyChanged("height")
        }
    },
    get_unit: function() {
        this._horizontalAnimation.get_unit()
    },
    set_unit: function(b) {
        var a = this
          , c = a._horizontalAnimation.get_unit();
        if (c != b) {
            a._horizontalAnimation.set_unit(b);
            a._verticalAnimation.set_unit(b);
            a.raisePropertyChanged("unit")
        }
    }
};
$AA.ResizeAnimation.registerClass("AjaxControlToolkit.Animation.ResizeAnimation", $AA.ParallelAnimation);
$AA.registerAnimation("resize", $AA.ResizeAnimation);
$AA.ScaleAnimation = function(i, g, j, c, e, h, f, d) {
    var b = null
      , a = this;
    $AA.ScaleAnimation.initializeBase(a, [i, g, j]);
    a._scaleFactor = c !== undefined ? c : 1;
    a._unit = e !== undefined ? e : "px";
    a._center = h;
    a._scaleFont = f;
    a._fontUnit = d !== undefined ? d : "pt";
    a._element = b;
    a._initialHeight = b;
    a._initialWidth = b;
    a._initialTop = b;
    a._initialLeft = b;
    a._initialFontSize = b
}
;
$AA.ScaleAnimation.prototype = {
    getAnimatedValue: function(a) {
        return this.interpolate(1, this._scaleFactor, a)
    },
    onStart: function() {
        var a = this;
        $AA.ScaleAnimation.callBaseMethod(a, "onStart");
        a._element = a.get_target();
        if (a._element) {
            a._initialHeight = a._element.offsetHeight;
            a._initialWidth = a._element.offsetWidth;
            if (a._center) {
                a._initialTop = a._element.offsetTop;
                a._initialLeft = a._element.offsetLeft
            }
            if (a._scaleFont)
                a._initialFontSize = parseFloat($common.getCurrentStyle(a._element, "fontSize"))
        }
    },
    setValue: function(b) {
        var a = this;
        if (a._element) {
            var e = Math.round(a._initialWidth * b)
              , d = Math.round(a._initialHeight * b);
            a._element.style.width = e + a._unit;
            a._element.style.height = d + a._unit;
            if (a._center) {
                a._element.style.top = a._initialTop + Math.round((a._initialHeight - d) / 2) + a._unit;
                a._element.style.left = a._initialLeft + Math.round((a._initialWidth - e) / 2) + a._unit
            }
            if (a._scaleFont) {
                var c = a._initialFontSize * b;
                if (a._fontUnit == "px" || a._fontUnit == "pt")
                    c = Math.round(c);
                a._element.style.fontSize = c + a._fontUnit
            }
        }
    },
    onEnd: function() {
        var b = null
          , a = this;
        a._element = b;
        a._initialHeight = b;
        a._initialWidth = b;
        a._initialTop = b;
        a._initialLeft = b;
        a._initialFontSize = b;
        $AA.ScaleAnimation.callBaseMethod(a, "onEnd")
    },
    get_scaleFactor: function() {
        return this._scaleFactor
    },
    set_scaleFactor: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._scaleFactor != b) {
            a._scaleFactor = b;
            a.raisePropertyChanged("scaleFactor")
        }
    },
    get_unit: function() {
        return this._unit
    },
    set_unit: function(a) {
        if (this._unit != a) {
            this._unit = a;
            this.raisePropertyChanged("unit")
        }
    },
    get_center: function() {
        return this._center
    },
    set_center: function(b) {
        var a = this;
        b = a._getBoolean(b);
        if (a._center != b) {
            a._center = b;
            a.raisePropertyChanged("center")
        }
    },
    get_scaleFont: function() {
        return this._scaleFont
    },
    set_scaleFont: function(b) {
        var a = this;
        b = a._getBoolean(b);
        if (a._scaleFont != b) {
            a._scaleFont = b;
            a.raisePropertyChanged("scaleFont")
        }
    },
    get_fontUnit: function() {
        return this._fontUnit
    },
    set_fontUnit: function(a) {
        if (this._fontUnit != a) {
            this._fontUnit = a;
            this.raisePropertyChanged("fontUnit")
        }
    }
};
$AA.ScaleAnimation.registerClass("AjaxControlToolkit.Animation.ScaleAnimation", $AA.Animation);
$AA.registerAnimation("scale", $AA.ScaleAnimation);
$AA.Action = function(b, a, c) {
    $AA.Action.initializeBase(this, [b, a, c]);
    a === undefined && this.set_duration(0)
}
;
$AA.Action.prototype = {
    onEnd: function() {
        this.doAction();
        $AA.Action.callBaseMethod(this, "onEnd")
    },
    doAction: function() {
        throw Error.notImplemented();
    },
    getAnimatedValue: function() {},
    setValue: function() {}
};
$AA.Action.registerClass("AjaxControlToolkit.Animation.Action", $AA.Animation);
$AA.registerAnimation("action", $AA.Action);
$AA.EnableAction = function(c, b, d, a) {
    $AA.EnableAction.initializeBase(this, [c, b, d]);
    this._enabled = a !== undefined ? a : true
}
;
$AA.EnableAction.prototype = {
    doAction: function() {
        var a = this.get_target();
        if (a)
            a.disabled = !this._enabled
    },
    get_enabled: function() {
        return this._enabled
    },
    set_enabled: function(b) {
        var a = this;
        b = a._getBoolean(b);
        if (a._enabled != b) {
            a._enabled = b;
            a.raisePropertyChanged("enabled")
        }
    }
};
$AA.EnableAction.registerClass("AjaxControlToolkit.Animation.EnableAction", $AA.Action);
$AA.registerAnimation("enableAction", $AA.EnableAction);
$AA.HideAction = function(c, a, d, b) {
    $AA.HideAction.initializeBase(this, [c, a, d]);
    this._visible = b
}
;
$AA.HideAction.prototype = {
    doAction: function() {
        var a = this.get_target();
        a && $common.setVisible(a, this._visible)
    },
    get_visible: function() {
        return this._visible
    },
    set_visible: function(a) {
        if (this._visible != a) {
            this._visible = a;
            this.raisePropertyChanged("visible")
        }
    }
};
$AA.HideAction.registerClass("AjaxControlToolkit.Animation.HideAction", $AA.Action);
$AA.registerAnimation("hideAction", $AA.HideAction);
$AA.StyleAction = function(c, b, e, a, d) {
    $AA.StyleAction.initializeBase(this, [c, b, e]);
    this._attribute = a;
    this._value = d
}
;
$AA.StyleAction.prototype = {
    doAction: function() {
        var a = this.get_target();
        if (a)
            a.style[this._attribute] = this._value
    },
    get_attribute: function() {
        return this._attribute
    },
    set_attribute: function(a) {
        if (this._attribute != a) {
            this._attribute = a;
            this.raisePropertyChanged("attribute")
        }
    },
    get_value: function() {
        return this._value
    },
    set_value: function(a) {
        if (this._value != a) {
            this._value = a;
            this.raisePropertyChanged("value")
        }
    }
};
$AA.StyleAction.registerClass("AjaxControlToolkit.Animation.StyleAction", $AA.Action);
$AA.registerAnimation("styleAction", $AA.StyleAction);
$AA.OpacityAction = function(c, a, d, b) {
    $AA.OpacityAction.initializeBase(this, [c, a, d]);
    this._opacity = b
}
;
$AA.OpacityAction.prototype = {
    doAction: function() {
        var a = this.get_target();
        a && $common.setElementOpacity(a, this._opacity)
    },
    get_opacity: function() {
        return this._opacity
    },
    set_opacity: function(b) {
        var a = this;
        b = a._getFloat(b);
        if (a._opacity != b) {
            a._opacity = b;
            a.raisePropertyChanged("opacity")
        }
    }
};
$AA.OpacityAction.registerClass("AjaxControlToolkit.Animation.OpacityAction", $AA.Action);
$AA.registerAnimation("opacityAction", $AA.OpacityAction);
$AA.ScriptAction = function(c, a, d, b) {
    $AA.ScriptAction.initializeBase(this, [c, a, d]);
    this._script = b
}
;
$AA.ScriptAction.prototype = {
    doAction: function() {
        try {
            eval(this._script)
        } catch (a) {}
    },
    get_script: function() {
        return this._script
    },
    set_script: function(a) {
        if (this._script != a) {
            this._script = a;
            this.raisePropertyChanged("script")
        }
    }
};
$AA.ScriptAction.registerClass("AjaxControlToolkit.Animation.ScriptAction", $AA.Action);
$AA.registerAnimation("scriptAction", $AA.ScriptAction);
//END AjaxControlToolkit.Animation.Animations.js
//START AjaxControlToolkit.ExtenderBase.BaseScripts.js
Type.registerNamespace("AjaxControlToolkit");
AjaxControlToolkit.BehaviorBase = function(c) {
    var b = null
      , a = this;
    AjaxControlToolkit.BehaviorBase.initializeBase(a, [c]);
    a._clientStateFieldID = b;
    a._pageRequestManager = b;
    a._partialUpdateBeginRequestHandler = b;
    a._partialUpdateEndRequestHandler = b
}
;
AjaxControlToolkit.BehaviorBase.prototype = {
    initialize: function() {
        AjaxControlToolkit.BehaviorBase.callBaseMethod(this, "initialize")
    },
    dispose: function() {
        var a = this;
        AjaxControlToolkit.BehaviorBase.callBaseMethod(a, "dispose");
        if (a._pageRequestManager) {
            if (a._partialUpdateBeginRequestHandler) {
                a._pageRequestManager.remove_beginRequest(a._partialUpdateBeginRequestHandler);
                a._partialUpdateBeginRequestHandler = null
            }
            if (a._partialUpdateEndRequestHandler) {
                a._pageRequestManager.remove_endRequest(a._partialUpdateEndRequestHandler);
                a._partialUpdateEndRequestHandler = null
            }
            a._pageRequestManager = null
        }
    },
    get_ClientStateFieldID: function() {
        return this._clientStateFieldID
    },
    set_ClientStateFieldID: function(a) {
        if (this._clientStateFieldID != a) {
            this._clientStateFieldID = a;
            this.raisePropertyChanged("ClientStateFieldID")
        }
    },
    get_ClientState: function() {
        if (this._clientStateFieldID) {
            var a = document.getElementById(this._clientStateFieldID);
            if (a)
                return a.value
        }
        return null
    },
    set_ClientState: function(b) {
        if (this._clientStateFieldID) {
            var a = document.getElementById(this._clientStateFieldID);
            if (a)
                a.value = b
        }
    },
    registerPartialUpdateEvents: function() {
        var a = this;
        if (Sys && Sys.WebForms && Sys.WebForms.PageRequestManager) {
            a._pageRequestManager = Sys.WebForms.PageRequestManager.getInstance();
            if (a._pageRequestManager) {
                a._partialUpdateBeginRequestHandler = Function.createDelegate(a, a._partialUpdateBeginRequest);
                a._pageRequestManager.add_beginRequest(a._partialUpdateBeginRequestHandler);
                a._partialUpdateEndRequestHandler = Function.createDelegate(a, a._partialUpdateEndRequest);
                a._pageRequestManager.add_endRequest(a._partialUpdateEndRequestHandler)
            }
        }
    },
    _partialUpdateBeginRequest: function() {},
    _partialUpdateEndRequest: function() {}
};
AjaxControlToolkit.BehaviorBase.registerClass("AjaxControlToolkit.BehaviorBase", Sys.UI.Behavior);
AjaxControlToolkit.DynamicPopulateBehaviorBase = function(c) {
    var b = null
      , a = this;
    AjaxControlToolkit.DynamicPopulateBehaviorBase.initializeBase(a, [c]);
    a._DynamicControlID = b;
    a._DynamicContextKey = b;
    a._DynamicServicePath = b;
    a._DynamicServiceMethod = b;
    a._cacheDynamicResults = false;
    a._dynamicPopulateBehavior = b;
    a._populatingHandler = b;
    a._populatedHandler = b
}
;
AjaxControlToolkit.DynamicPopulateBehaviorBase.prototype = {
    initialize: function() {
        var a = this;
        AjaxControlToolkit.DynamicPopulateBehaviorBase.callBaseMethod(a, "initialize");
        a._populatingHandler = Function.createDelegate(a, a._onPopulating);
        a._populatedHandler = Function.createDelegate(a, a._onPopulated)
    },
    dispose: function() {
        var a = this;
        if (a._populatedHandler) {
            a._dynamicPopulateBehavior && a._dynamicPopulateBehavior.remove_populated(a._populatedHandler);
            a._populatedHandler = null
        }
        if (a._populatingHandler) {
            a._dynamicPopulateBehavior && a._dynamicPopulateBehavior.remove_populating(a._populatingHandler);
            a._populatingHandler = null
        }
        if (a._dynamicPopulateBehavior) {
            a._dynamicPopulateBehavior.dispose();
            a._dynamicPopulateBehavior = null
        }
        AjaxControlToolkit.DynamicPopulateBehaviorBase.callBaseMethod(a, "dispose")
    },
    populate: function(b) {
        var a = this;
        if (a._dynamicPopulateBehavior && a._dynamicPopulateBehavior.get_element() != $get(a._DynamicControlID)) {
            a._dynamicPopulateBehavior.dispose();
            a._dynamicPopulateBehavior = null
        }
        if (!a._dynamicPopulateBehavior && a._DynamicControlID && a._DynamicServiceMethod) {
            a._dynamicPopulateBehavior = $create(AjaxControlToolkit.DynamicPopulateBehavior, {
                id: a.get_id() + "_DynamicPopulateBehavior",
                ContextKey: a._DynamicContextKey,
                ServicePath: a._DynamicServicePath,
                ServiceMethod: a._DynamicServiceMethod,
                cacheDynamicResults: a._cacheDynamicResults
            }, null, null, $get(a._DynamicControlID));
            a._dynamicPopulateBehavior.add_populating(a._populatingHandler);
            a._dynamicPopulateBehavior.add_populated(a._populatedHandler)
        }
        a._dynamicPopulateBehavior && a._dynamicPopulateBehavior.populate(b ? b : a._DynamicContextKey)
    },
    _onPopulating: function(b, a) {
        this.raisePopulating(a)
    },
    _onPopulated: function(b, a) {
        this.raisePopulated(a)
    },
    get_dynamicControlID: function() {
        return this._DynamicControlID
    },
    get_DynamicControlID: this.get_dynamicControlID,
    set_dynamicControlID: function(b) {
        var a = this;
        if (a._DynamicControlID != b) {
            a._DynamicControlID = b;
            a.raisePropertyChanged("dynamicControlID");
            a.raisePropertyChanged("DynamicControlID")
        }
    },
    set_DynamicControlID: this.set_dynamicControlID,
    get_dynamicContextKey: function() {
        return this._DynamicContextKey
    },
    get_DynamicContextKey: this.get_dynamicContextKey,
    set_dynamicContextKey: function(b) {
        var a = this;
        if (a._DynamicContextKey != b) {
            a._DynamicContextKey = b;
            a.raisePropertyChanged("dynamicContextKey");
            a.raisePropertyChanged("DynamicContextKey")
        }
    },
    set_DynamicContextKey: this.set_dynamicContextKey,
    get_dynamicServicePath: function() {
        return this._DynamicServicePath
    },
    get_DynamicServicePath: this.get_dynamicServicePath,
    set_dynamicServicePath: function(b) {
        var a = this;
        if (a._DynamicServicePath != b) {
            a._DynamicServicePath = b;
            a.raisePropertyChanged("dynamicServicePath");
            a.raisePropertyChanged("DynamicServicePath")
        }
    },
    set_DynamicServicePath: this.set_dynamicServicePath,
    get_dynamicServiceMethod: function() {
        return this._DynamicServiceMethod
    },
    get_DynamicServiceMethod: this.get_dynamicServiceMethod,
    set_dynamicServiceMethod: function(b) {
        var a = this;
        if (a._DynamicServiceMethod != b) {
            a._DynamicServiceMethod = b;
            a.raisePropertyChanged("dynamicServiceMethod");
            a.raisePropertyChanged("DynamicServiceMethod")
        }
    },
    set_DynamicServiceMethod: this.set_dynamicServiceMethod,
    get_cacheDynamicResults: function() {
        return this._cacheDynamicResults
    },
    set_cacheDynamicResults: function(a) {
        if (this._cacheDynamicResults != a) {
            this._cacheDynamicResults = a;
            this.raisePropertyChanged("cacheDynamicResults")
        }
    },
    add_populated: function(a) {
        this.get_events().addHandler("populated", a)
    },
    remove_populated: function(a) {
        this.get_events().removeHandler("populated", a)
    },
    raisePopulated: function(b) {
        var a = this.get_events().getHandler("populated");
        a && a(this, b)
    },
    add_populating: function(a) {
        this.get_events().addHandler("populating", a)
    },
    remove_populating: function(a) {
        this.get_events().removeHandler("populating", a)
    },
    raisePopulating: function(b) {
        var a = this.get_events().getHandler("populating");
        a && a(this, b)
    }
};
AjaxControlToolkit.DynamicPopulateBehaviorBase.registerClass("AjaxControlToolkit.DynamicPopulateBehaviorBase", AjaxControlToolkit.BehaviorBase);
AjaxControlToolkit.ControlBase = function(b) {
    var a = this;
    AjaxControlToolkit.ControlBase.initializeBase(a, [b]);
    a._clientStateField = null;
    a._callbackTarget = null;
    a._onsubmit$delegate = Function.createDelegate(a, a._onsubmit);
    a._oncomplete$delegate = Function.createDelegate(a, a._oncomplete);
    a._onerror$delegate = Function.createDelegate(a, a._onerror)
}
;
AjaxControlToolkit.ControlBase.__doPostBack = function(c, b) {
    if (!Sys.WebForms.PageRequestManager.getInstance().get_isInAsyncPostBack())
        for (var a = 0; a < AjaxControlToolkit.ControlBase.onsubmitCollection.length; a++)
            AjaxControlToolkit.ControlBase.onsubmitCollection[a]();
    Function.createDelegate(window, AjaxControlToolkit.ControlBase.__doPostBackSaved)(c, b)
}
;
AjaxControlToolkit.ControlBase.prototype = {
    initialize: function() {
        var b = "undefined"
          , a = this;
        AjaxControlToolkit.ControlBase.callBaseMethod(a, "initialize");
        a._clientStateField && a.loadClientState(a._clientStateField.value);
        if (typeof Sys.WebForms !== b && typeof Sys.WebForms.PageRequestManager !== b) {
            Array.add(Sys.WebForms.PageRequestManager.getInstance()._onSubmitStatements, a._onsubmit$delegate);
            if (AjaxControlToolkit.ControlBase.__doPostBackSaved == null || typeof AjaxControlToolkit.ControlBase.__doPostBackSaved == b) {
                AjaxControlToolkit.ControlBase.__doPostBackSaved = window.__doPostBack;
                window.__doPostBack = AjaxControlToolkit.ControlBase.__doPostBack;
                AjaxControlToolkit.ControlBase.onsubmitCollection = []
            }
            Array.add(AjaxControlToolkit.ControlBase.onsubmitCollection, a._onsubmit$delegate)
        } else
            $addHandler(document.forms[0], "submit", a._onsubmit$delegate)
    },
    dispose: function() {
        var b = "undefined"
          , a = this;
        if (typeof Sys.WebForms !== b && typeof Sys.WebForms.PageRequestManager !== b) {
            Array.remove(AjaxControlToolkit.ControlBase.onsubmitCollection, a._onsubmit$delegate);
            Array.remove(Sys.WebForms.PageRequestManager.getInstance()._onSubmitStatements, a._onsubmit$delegate)
        } else
            $removeHandler(document.forms[0], "submit", a._onsubmit$delegate);
        AjaxControlToolkit.ControlBase.callBaseMethod(a, "dispose")
    },
    findElement: function(a) {
        return $get(this.get_id() + "_" + a.split(":").join("_"))
    },
    get_clientStateField: function() {
        return this._clientStateField
    },
    set_clientStateField: function(b) {
        var a = this;
        if (a.get_isInitialized())
            throw Error.invalidOperation(AjaxControlToolkit.Resources.ExtenderBase_CannotSetClientStateField);
        if (a._clientStateField != b) {
            a._clientStateField = b;
            a.raisePropertyChanged("clientStateField")
        }
    },
    loadClientState: function() {},
    saveClientState: function() {
        return null
    },
    _invoke: function(g, d, h) {
        var a = this;
        if (!a._callbackTarget)
            throw Error.invalidOperation(AjaxControlToolkit.Resources.ExtenderBase_ControlNotRegisteredForCallbacks);
        if (typeof WebForm_DoCallback === "undefined")
            throw Error.invalidOperation(AjaxControlToolkit.Resources.ExtenderBase_PageNotRegisteredForCallbacks);
        for (var e = [], b = 0; b < d.length; b++)
            e[b] = d[b];
        var c = a.saveClientState();
        if (c != null && !String.isInstanceOfType(c))
            throw Error.invalidOperation(AjaxControlToolkit.Resources.ExtenderBase_InvalidClientStateType);
        var f = Sys.Serialization.JavaScriptSerializer.serialize({
            name: g,
            args: e,
            state: a.saveClientState()
        });
        WebForm_DoCallback(a._callbackTarget, f, a._oncomplete$delegate, h, a._onerror$delegate, true)
    },
    _oncomplete: function(a, b) {
        a = Sys.Serialization.JavaScriptSerializer.deserialize(a);
        if (a.error)
            throw Error.create(a.error);
        this.loadClientState(a.state);
        b(a.result)
    },
    _onerror: function(a) {
        throw Error.create(a);
    },
    _onsubmit: function() {
        if (this._clientStateField)
            this._clientStateField.value = this.saveClientState();
        return true
    }
};
AjaxControlToolkit.ControlBase.registerClass("AjaxControlToolkit.ControlBase", Sys.UI.Control);
AjaxControlToolkit.Resources = {
    "PasswordStrength_InvalidWeightingRatios": "Strength Weighting ratios must have 4 elements",
    "HTMLEditor_toolbar_button_FontSize_defaultValue": "default",
    "HTMLEditor_toolbar_button_DesignMode_title": "Design mode",
    "Animation_ChildrenNotAllowed": "AjaxControlToolkit.Animation.createAnimation cannot add child animations to type \"{0}\" that does not derive from AjaxControlToolkit.Animation.ParentAnimation",
    "PasswordStrength_RemainingSymbols": "{0} symbol characters",
    "HTMLEditor_toolbar_button_FixedForeColor_title": "Foreground color",
    "HTMLEditor_toolbar_popup_LinkProperties_field_URL": "URL",
    "ExtenderBase_CannotSetClientStateField": "clientStateField can only be set before initialization",
    "HTMLEditor_toolbar_button_Bold_title": "Bold",
    "RTE_PreviewHTML": "Preview HTML",
    "HTMLEditor_toolbar_popup_LinkProperties_button_OK": "OK",
    "HTMLEditor_toolbar_button_JustifyRight_title": "Justify Right",
    "RTE_JustifyCenter": "Justify Center",
    "PasswordStrength_RemainingUpperCase": "{0} more upper case characters",
    "HTMLEditor_toolbar_popup_LinkProperties_button_Cancel": "Cancel",
    "Animation_TargetNotFound": "AjaxControlToolkit.Animation.Animation.set_animationTarget requires the ID of a Sys.UI.DomElement or Sys.UI.Control.  No element or control could be found corresponding to \"{0}\"",
    "AsyncFileUpload_UnhandledException": "Unhandled Exception",
    "RTE_FontColor": "Font Color",
    "RTE_LabelColor": "Label Color",
    "Common_InvalidBorderWidthUnit": "A unit type of \"{0}\"\u0027 is invalid for parseBorderWidth",
    "HTMLEditor_toolbar_button_JustifyFull_title": "Justify",
    "RTE_Heading": "Heading",
    "AsyncFileUpload_ConfirmToSeeErrorPage": "Do you want to see the response page?",
    "Tabs_PropertySetBeforeInitialization": "{0} cannot be changed before initialization",
    "HTMLEditor_toolbar_button_StrikeThrough_title": "Strike through",
    "RTE_OrderedList": "Ordered List",
    "HTMLEditor_toolbar_button_OnPastePlainText": "Plain text pasting is switched on. Just now: {0}",
    "HTMLEditor_toolbar_button_RemoveLink_title": "Remove Link",
    "HTMLEditor_toolbar_button_FontName_defaultValue": "default",
    "HTMLEditor_toolbar_button_FontName_label": "Font",
    "ReorderList_DropWatcherBehavior_NoChild": "Could not find child of list with id \"{0}\"",
    "CascadingDropDown_MethodTimeout": "[Method timeout]",
    "RTE_Columns": "Columns",
    "RTE_InsertImage": "Insert Image",
    "RTE_InsertTable": "Insert Table",
    "RTE_Values": "Values",
    "RTE_OK": "OK",
    "ExtenderBase_PageNotRegisteredForCallbacks": "This Page has not been registered for callbacks",
    "HTMLEditor_toolbar_button_InsertLink_title": "Insert/Edit URL link",
    "Animation_NoDynamicPropertyFound": "AjaxControlToolkit.Animation.createAnimation found no property corresponding to \"{0}\" or \"{1}\"",
    "Animation_InvalidBaseType": "AjaxControlToolkit.Animation.registerAnimation can only register types that inherit from AjaxControlToolkit.Animation.Animation",
    "RTE_UnorderedList": "Unordered List",
    "AsyncFileUpload_UnknownServerError": "Unknown Server error",
    "ResizableControlBehavior_InvalidHandler": "{0} handler not a function, function name, or function text",
    "Animation_InvalidColor": "Color must be a 7-character hex representation (e.g. #246ACF), not \"{0}\"",
    "RTE_CellColor": "Cell Color",
    "PasswordStrength_RemainingMixedCase": "Mixed case characters",
    "HTMLEditor_toolbar_button_HtmlMode_title": "HTML text",
    "RTE_Italic": "Italic",
    "CascadingDropDown_NoParentElement": "Failed to find parent element \"{0}\"",
    "ValidatorCallout_DefaultErrorMessage": "This control is invalid",
    "HTMLEditor_toolbar_button_DecreaseIndent_title": "Decrease Indent",
    "RTE_Indent": "Indent",
    "ReorderList_DropWatcherBehavior_CallbackError": "Reorder failed, see details below.\\r\\n\\r\\n{0}",
    "PopupControl_NoDefaultProperty": "No default property supported for control \"{0}\" of type \"{1}\"",
    "RTE_Normal": "Normal",
    "PopupExtender_NoParentElement": "Couldn\u0027t find parent element \"{0}\"",
    "RTE_ViewValues": "View Values",
    "RTE_Legend": "Legend",
    "RTE_Labels": "Labels",
    "RTE_CellSpacing": "Cell Spacing",
    "PasswordStrength_RemainingNumbers": "{0} more numbers",
    "HTMLEditor_toolbar_popup_LinkProperties_field_Target": "Target",
    "HTMLEditor_toolbar_button_PreviewMode_title": "Preview",
    "RTE_Border": "Border",
    "RTE_Create": "Create",
    "RTE_BackgroundColor": "Background Color",
    "RTE_Cancel": "Cancel",
    "HTMLEditor_toolbar_button_PasteText_title": "Paste Plain Text",
    "RTE_JustifyFull": "Justify Full",
    "RTE_JustifyLeft": "Justify Left",
    "RTE_Cut": "Cut",
    "AsyncFileUpload_UploadingProblem": "The requested file uploading problem.",
    "ResizableControlBehavior_CannotChangeProperty": "Changes to {0} not supported",
    "RTE_ViewSource": "View Source",
    "Common_InvalidPaddingUnit": "A unit type of \"{0}\" is invalid for parsePadding",
    "RTE_Paste": "Paste",
    "ExtenderBase_ControlNotRegisteredForCallbacks": "This Control has not been registered for callbacks",
    "Calendar_Today": "Today: {0}",
    "MultiHandleSlider_CssHeightWidthRequired": "You must specify a CSS width and height for all handle styles as well as the rail.",
    "Common_DateTime_InvalidFormat": "Invalid format",
    "HTMLEditor_toolbar_button_Copy_title": "Copy",
    "ListSearch_DefaultPrompt": "Type to search",
    "CollapsiblePanel_NoControlID": "Failed to find element \"{0}\"",
    "RTE_ViewEditor": "View Editor",
    "HTMLEditor_toolbar_popup_LinkProperties_field_Target_Current": "Current window",
    "RTE_BarColor": "Bar Color",
    "AsyncFileUpload_InternalErrorMessage": "The AsyncFileUpload control has encountered an error with the uploader in this page. Please refresh the page and try again.",
    "HTMLEditor_toolbar_button_Underline_title": "Underline",
    "PasswordStrength_DefaultStrengthDescriptions": "NonExistent;Very Weak;Weak;Poor;Almost OK;Barely Acceptable;Average;Good;Strong;Excellent;Unbreakable!",
    "HTMLEditor_toolbar_button_SuperScript_title": "Super script",
    "HTMLEditor_toolbar_button_Ltr_title": "Left to right direction",
    "HTMLEditor_toolbar_button_RemoveAlignment_title": "Remove Alignment",
    "HTMLEditor_toolbar_button_OrderedList_title": "Ordered List",
    "HTMLEditor_toolbar_popup_LinkProperties_field_Target_New": "New window",
    "HTMLEditor_toolbar_popup_LinkProperties_field_Target_Top": "Top window",
    "HTMLEditor_toolbar_button_JustifyCenter_title": "Justify Center",
    "RTE_Inserttexthere": "Insert text here",
    "Animation_UknownAnimationName": "AjaxControlToolkit.Animation.createAnimation could not find an Animation corresponding to the name \"{0}\"",
    "ExtenderBase_InvalidClientStateType": "saveClientState must return a value of type String",
    "HTMLEditor_toolbar_button_JustifyLeft_title": "Justify Left",
    "Rating_CallbackError": "An unhandled exception has occurred:\\r\\n{0}",
    "HTMLEditor_toolbar_button_Undo_title": "Undo",
    "HTMLEditor_toolbar_button_Redo_title": "Redo",
    "Tabs_OwnerExpected": "owner must be set before initialize",
    "DynamicPopulate_WebServiceTimeout": "Web service call timed out",
    "PasswordStrength_RemainingLowerCase": "{0} more lower case characters",
    "HTMLEditor_toolbar_button_BulletedList_title": "Bulleted List",
    "HTMLEditor_toolbar_button_Paste_title": "Paste",
    "Animation_MissingAnimationName": "AjaxControlToolkit.Animation.createAnimation requires an object with an AnimationName property",
    "HTMLEditor_toolbar_button_PasteWord_title": "Paste from MS Word (with cleanup)",
    "HTMLEditor_toolbar_button_Italic_title": "Italic",
    "RTE_JustifyRight": "Justify Right",
    "Tabs_ActiveTabArgumentOutOfRange": "Argument is not a member of the tabs collection",
    "RTE_CellPadding": "Cell Padding",
    "HTMLEditor_toolbar_button_ForeColorClear_title": "Clear foreground color",
    "RTE_ClearFormatting": "Clear Formatting",
    "AlwaysVisible_ElementRequired": "AjaxControlToolkit.AlwaysVisibleControlBehavior must have an element",
    "HTMLEditor_toolbar_button_SubScript_title": "Sub script",
    "Slider_NoSizeProvided": "Please set valid values for the height and width attributes in the slider\u0027s CSS classes",
    "DynamicPopulate_WebServiceError": "Web Service call failed: {0}",
    "PasswordStrength_StrengthPrompt": "Strength: ",
    "HTMLEditor_toolbar_button_Rtl_title": "Right to left direction",
    "PasswordStrength_RemainingCharacters": "{0} more characters",
    "HTMLEditor_toolbar_button_BackColorClear_title": "Clear background color",
    "PasswordStrength_Satisfied": "Nothing more required",
    "RTE_Hyperlink": "Hyperlink",
    "Animation_NoPropertyFound": "AjaxControlToolkit.Animation.createAnimation found no property corresponding to \"{0}\"",
    "PasswordStrength_InvalidStrengthDescriptionStyles": "Text Strength description style classes must match the number of text descriptions.",
    "HTMLEditor_toolbar_button_Use_verb": "Use {0}",
    "HTMLEditor_toolbar_popup_LinkProperties_field_Target_Parent": "Parent window",
    "PasswordStrength_GetHelpRequirements": "Get help on password requirements",
    "HTMLEditor_toolbar_button_FixedBackColor_title": "Background color",
    "PasswordStrength_InvalidStrengthDescriptions": "Invalid number of text strength descriptions specified",
    "RTE_Underline": "Underline",
    "HTMLEditor_toolbar_button_IncreaseIndent_title": "Increase Indent",
    "AsyncFileUpload_ServerResponseError": "Server Response Error",
    "Tabs_PropertySetAfterInitialization": "{0} cannot be changed after initialization",
    "RTE_Rows": "Rows",
    "RTE_Redo": "Redo",
    "RTE_Size": "Size",
    "RTE_Undo": "Undo",
    "RTE_Bold": "Bold",
    "RTE_Copy": "Copy",
    "RTE_Font": "Font",
    "HTMLEditor_toolbar_button_FontSize_label": "Size",
    "HTMLEditor_toolbar_button_Cut_title": "Cut",
    "CascadingDropDown_MethodError": "[Method error {0}]",
    "HTMLEditor_toolbar_button_InsertLink_message_EmptyURL": "URL can not be empty",
    "RTE_BorderColor": "Border Color",
    "HTMLEditor_toolbar_button_RemoveStyles_title": "Remove styles",
    "RTE_Paragraph": "Paragraph",
    "RTE_InsertHorizontalRule": "Insert Horizontal Rule",
    "HTMLEditor_toolbar_button_Paragraph_title": "Make Paragraph",
    "Common_UnitHasNoDigits": "No digits",
    "RTE_Outdent": "Outdent",
    "Common_DateTime_InvalidTimeSpan": "\"{0}\" is not a valid TimeSpan format",
    "Animation_CannotNestSequence": "AjaxControlToolkit.Animation.SequenceAnimation cannot be nested inside AjaxControlToolkit.Animation.ParallelAnimation",
    "HTMLEditor_toolbar_button_InsertHR_title": "Insert horizontal rule",
    "HTMLEditor_toolbar_button_OnPasteFromMSWord": "Pasting from MS Word is switched on. Just now: {0}",
    "Shared_BrowserSecurityPreventsPaste": "Your browser security settings don\u0027t permit the automatic execution of paste operations. Please use the keyboard shortcut Ctrl+V instead."
};
//END AjaxControlToolkit.ExtenderBase.BaseScripts.js
//START AjaxControlToolkit.Animation.AnimationBehavior.js
Type.registerNamespace("AjaxControlToolkit.Animation");
AjaxControlToolkit.Animation.AnimationBehavior = function(c) {
    var b = null
      , a = this;
    AjaxControlToolkit.Animation.AnimationBehavior.initializeBase(a, [c]);
    a._onLoad = b;
    a._onClick = b;
    a._onMouseOver = b;
    a._onMouseOut = b;
    a._onHoverOver = b;
    a._onHoverOut = b;
    a._onClickHandler = b;
    a._onMouseOverHandler = b;
    a._onMouseOutHandler = b
}
;
AjaxControlToolkit.Animation.AnimationBehavior.prototype = {
    initialize: function() {
        var a = this;
        AjaxControlToolkit.Animation.AnimationBehavior.callBaseMethod(a, "initialize");
        var b = a.get_element();
        if (b) {
            a._onClickHandler = Function.createDelegate(a, a.OnClick);
            $addHandler(b, "click", a._onClickHandler);
            a._onMouseOverHandler = Function.createDelegate(a, a.OnMouseOver);
            $addHandler(b, "mouseover", a._onMouseOverHandler);
            a._onMouseOutHandler = Function.createDelegate(a, a.OnMouseOut);
            $addHandler(b, "mouseout", a._onMouseOutHandler)
        }
    },
    dispose: function() {
        var b = null
          , a = this
          , c = a.get_element();
        if (c) {
            if (a._onClickHandler) {
                $removeHandler(c, "click", a._onClickHandler);
                a._onClickHandler = b
            }
            if (a._onMouseOverHandler) {
                $removeHandler(c, "mouseover", a._onMouseOverHandler);
                a._onMouseOverHandler = b
            }
            if (a._onMouseOutHandler) {
                $removeHandler(c, "mouseout", a._onMouseOutHandler);
                a._onMouseOutHandler = b
            }
        }
        a._onLoad = b;
        a._onClick = b;
        a._onMouseOver = b;
        a._onMouseOut = b;
        a._onHoverOver = b;
        a._onHoverOut = b;
        AjaxControlToolkit.Animation.AnimationBehavior.callBaseMethod(a, "dispose")
    },
    get_OnLoad: function() {
        return this._onLoad ? this._onLoad.get_json() : null
    },
    set_OnLoad: function(b) {
        var a = this;
        if (!a._onLoad) {
            a._onLoad = new AjaxControlToolkit.Animation.GenericAnimationBehavior(a.get_element());
            a._onLoad.initialize()
        }
        a._onLoad.set_json(b);
        a.raisePropertyChanged("OnLoad");
        a._onLoad.play()
    },
    get_OnLoadBehavior: function() {
        return this._onLoad
    },
    get_OnClick: function() {
        return this._onClick ? this._onClick.get_json() : null
    },
    set_OnClick: function(b) {
        var a = this;
        if (!a._onClick) {
            a._onClick = new AjaxControlToolkit.Animation.GenericAnimationBehavior(a.get_element());
            a._onClick.initialize()
        }
        a._onClick.set_json(b);
        a.raisePropertyChanged("OnClick")
    },
    get_OnClickBehavior: function() {
        return this._onClick
    },
    OnClick: function() {
        this._onClick && this._onClick.play()
    },
    get_OnMouseOver: function() {
        return this._onMouseOver ? this._onMouseOver.get_json() : null
    },
    set_OnMouseOver: function(b) {
        var a = this;
        if (!a._onMouseOver) {
            a._onMouseOver = new AjaxControlToolkit.Animation.GenericAnimationBehavior(a.get_element());
            a._onMouseOver.initialize()
        }
        a._onMouseOver.set_json(b);
        a.raisePropertyChanged("OnMouseOver")
    },
    get_OnMouseOverBehavior: function() {
        return this._onMouseOver
    },
    OnMouseOver: function() {
        var a = this;
        a._onMouseOver && a._onMouseOver.play();
        if (a._onHoverOver) {
            a._onHoverOut && a._onHoverOut.quit();
            a._onHoverOver.play()
        }
    },
    get_OnMouseOut: function() {
        return this._onMouseOut ? this._onMouseOut.get_json() : null
    },
    set_OnMouseOut: function(b) {
        var a = this;
        if (!a._onMouseOut) {
            a._onMouseOut = new AjaxControlToolkit.Animation.GenericAnimationBehavior(a.get_element());
            a._onMouseOut.initialize()
        }
        a._onMouseOut.set_json(b);
        a.raisePropertyChanged("OnMouseOut")
    },
    get_OnMouseOutBehavior: function() {
        return this._onMouseOut
    },
    OnMouseOut: function() {
        var a = this;
        a._onMouseOut && a._onMouseOut.play();
        if (a._onHoverOut) {
            a._onHoverOver && a._onHoverOver.quit();
            a._onHoverOut.play()
        }
    },
    get_OnHoverOver: function() {
        return this._onHoverOver ? this._onHoverOver.get_json() : null
    },
    set_OnHoverOver: function(b) {
        var a = this;
        if (!a._onHoverOver) {
            a._onHoverOver = new AjaxControlToolkit.Animation.GenericAnimationBehavior(a.get_element());
            a._onHoverOver.initialize()
        }
        a._onHoverOver.set_json(b);
        a.raisePropertyChanged("OnHoverOver")
    },
    get_OnHoverOverBehavior: function() {
        return this._onHoverOver
    },
    get_OnHoverOut: function() {
        return this._onHoverOut ? this._onHoverOut.get_json() : null
    },
    set_OnHoverOut: function(b) {
        var a = this;
        if (!a._onHoverOut) {
            a._onHoverOut = new AjaxControlToolkit.Animation.GenericAnimationBehavior(a.get_element());
            a._onHoverOut.initialize()
        }
        a._onHoverOut.set_json(b);
        a.raisePropertyChanged("OnHoverOut")
    },
    get_OnHoverOutBehavior: function() {
        return this._onHoverOut
    }
};
AjaxControlToolkit.Animation.AnimationBehavior.registerClass("AjaxControlToolkit.Animation.AnimationBehavior", AjaxControlToolkit.BehaviorBase);
AjaxControlToolkit.Animation.GenericAnimationBehavior = function(a) {
    AjaxControlToolkit.Animation.GenericAnimationBehavior.initializeBase(this, [a]);
    this._json = null;
    this._animation = null
}
;
AjaxControlToolkit.Animation.GenericAnimationBehavior.prototype = {
    dispose: function() {
        this.disposeAnimation();
        AjaxControlToolkit.Animation.GenericAnimationBehavior.callBaseMethod(this, "dispose")
    },
    disposeAnimation: function() {
        this._animation && this._animation.dispose();
        this._animation = null
    },
    play: function() {
        var a = this;
        if (a._animation && !a._animation.get_isPlaying()) {
            a.stop();
            a._animation.play()
        }
    },
    stop: function() {
        if (this._animation)
            this._animation.get_isPlaying() && this._animation.stop(true)
    },
    quit: function() {
        if (this._animation)
            this._animation.get_isPlaying() && this._animation.stop(false)
    },
    get_json: function() {
        return this._json
    },
    set_json: function(c) {
        var a = this;
        if (a._json != c) {
            a._json = c;
            a.raisePropertyChanged("json");
            a.disposeAnimation();
            var b = a.get_element();
            if (b) {
                a._animation = AjaxControlToolkit.Animation.buildAnimation(a._json, b);
                a._animation && a._animation.initialize();
                a.raisePropertyChanged("animation")
            }
        }
    },
    get_animation: function() {
        return this._animation
    }
};
AjaxControlToolkit.Animation.GenericAnimationBehavior.registerClass("AjaxControlToolkit.Animation.GenericAnimationBehavior", AjaxControlToolkit.BehaviorBase);
//END AjaxControlToolkit.Animation.AnimationBehavior.js
//START AjaxControlToolkit.PopupExtender.PopupBehavior.js
Type.registerNamespace("AjaxControlToolkit");
AjaxControlToolkit.PopupBehavior = function(c) {
    var b = null
      , a = this;
    AjaxControlToolkit.PopupBehavior.initializeBase(a, [c]);
    a._x = 0;
    a._y = 0;
    a._positioningMode = AjaxControlToolkit.PositioningMode.Absolute;
    a._parentElement = b;
    a._parentElementID = b;
    a._moveHandler = b;
    a._firstPopup = true;
    a._originalParent = b;
    a._visible = false;
    a._onParentRepositionHandler = b;
    a._elementsWithAttachedRepositionHandlers = b;
    a._onShow = b;
    a._onShowEndedHandler = b;
    a._onHide = b;
    a._onHideEndedHandler = b
}
;
AjaxControlToolkit.PopupBehavior.prototype = {
    initialize: function() {
        var a = this;
        AjaxControlToolkit.PopupBehavior.callBaseMethod(a, "initialize");
        a._hidePopup();
        a._prepareElement();
        a._onShowEndedHandler = Function.createDelegate(a, a._onShowEnded);
        a._onHideEndedHandler = Function.createDelegate(a, a._onHideEnded)
    },
    dispose: function() {
        var b = null
          , a = this
          , c = a.get_element();
        if (c) {
            a._visible && a.hide();
            if (a._originalParent) {
                c.parentNode.removeChild(c);
                a._originalParent.appendChild(c);
                a._originalParent = b
            }
            c._hideWindowedElementsIFrame = b
        }
        a._parentElement = b;
        a._onShow && a._onShow.get_animation() && a._onShowEndedHandler && a._onShow.get_animation().remove_ended(a._onShowEndedHandler);
        a._onShowEndedHandler = b;
        a._onShow = b;
        a._onHide && a._onHide.get_animation() && a._onHideEndedHandler && a._onHide.get_animation().remove_ended(a._onHideEndedHandler);
        a._onHideEndedHandler = b;
        a._onHide = b;
        a._onParentRepositionHandler != b && $removeHandler(window, "resize", a._onParentRepositionHandler);
        if (a._elementsWithAttachedRepositionHandlers != b) {
            for (var d = 0; d < a._elementsWithAttachedRepositionHandlers.length; d++) {
                $removeHandler(a._elementsWithAttachedRepositionHandlers[d], "resize", a._onParentRepositionHandler);
                $removeHandler(a._elementsWithAttachedRepositionHandlers[d], "scroll", a._onParentRepositionHandler)
            }
            a._elementsWithAttachedRepositionHandlers = b
        }
        a._onParentRepositionHandler = b;
        AjaxControlToolkit.PopupBehavior.callBaseMethod(a, "dispose")
    },
    _prepareElement: function() {
        var a = this
          , c = a.get_element();
        a._onParentRepositionHandler = Function.createDelegate(a, a._reposition);
        a._elementsWithAttachedRepositionHandlers = [];
        var b = c.parentNode;
        while (b) {
            if (b == document.body)
                break;
            $addHandler(b, "scroll", a._onParentRepositionHandler);
            $addHandler(b, "resize", a._onParentRepositionHandler);
            a._elementsWithAttachedRepositionHandlers.push(b);
            b = b.parentNode
        }
        $addHandler(window, "resize", a._onParentRepositionHandler);
        c.style.position = "absolute";
        $common.appendElementToFormOrBody(c)
    },
    _reposition: function() {
        if (!this._visible)
            return;
        this.setupPopup()
    },
    show: function() {
        var a = this;
        if (a._visible)
            return;
        var b = new Sys.CancelEventArgs;
        a.raiseShowing(b);
        if (b.get_cancel())
            return;
        a._visible = true;
        var c = a.get_element();
        $common.setVisible(c, true);
        a.setupPopup();
        if (a._onShow) {
            $common.setVisible(c, false);
            a.onShow()
        } else
            a.raiseShown(Sys.EventArgs.Empty)
    },
    hide: function() {
        var a = this;
        if (!a._visible)
            return;
        var b = new Sys.CancelEventArgs;
        a.raiseHiding(b);
        if (b.get_cancel())
            return;
        a._visible = false;
        if (a._onHide)
            a.onHide();
        else {
            a._hidePopup();
            a._hideCleanup()
        }
    },
    getBounds: function() {
        var d = this, c = d.get_element(), j = c.offsetParent || document.documentElement, g, a;
        if (d._parentElement) {
            a = $common.getBounds(d._parentElement);
            var i = $common.getLocation(j);
            g = {
                x: a.x - i.x,
                y: a.y - i.y
            }
        } else {
            a = $common.getBounds(j);
            g = {
                x: 0,
                y: 0
            }
        }
        var e = c.offsetWidth - (c.clientLeft ? c.clientLeft * 2 : 0)
          , f = c.offsetHeight - (c.clientTop ? c.clientTop * 2 : 0);
        if (d._firstpopup) {
            c.style.width = e + "px";
            d._firstpopup = false
        }
        var h, b;
        switch (d._positioningMode) {
        case AjaxControlToolkit.PositioningMode.Center:
            b = {
                x: Math.round(a.width / 2 - e / 2),
                y: Math.round(a.height / 2 - f / 2),
                altX: Math.round(a.width / 2 - e / 2),
                altY: Math.round(a.height / 2 - f / 2)
            };
            break;
        case AjaxControlToolkit.PositioningMode.BottomLeft:
            b = {
                x: 0,
                y: a.height,
                altX: a.width - e,
                altY: 0 - f
            };
            break;
        case AjaxControlToolkit.PositioningMode.BottomRight:
            b = {
                x: a.width - e,
                y: a.height,
                altX: 0,
                altY: 0 - f
            };
            break;
        case AjaxControlToolkit.PositioningMode.TopLeft:
            b = {
                x: 0,
                y: -c.offsetHeight,
                altX: a.width - e,
                altY: a.height
            };
            break;
        case AjaxControlToolkit.PositioningMode.TopRight:
            b = {
                x: a.width - e,
                y: -c.offsetHeight,
                altX: 0,
                altY: a.height
            };
            break;
        case AjaxControlToolkit.PositioningMode.Right:
            b = {
                x: a.width,
                y: 0,
                altX: -c.offsetWidth,
                altY: a.height - f
            };
            break;
        case AjaxControlToolkit.PositioningMode.Left:
            b = {
                x: -c.offsetWidth,
                y: 0,
                altX: a.width,
                altY: a.height - f
            };
            break;
        default:
            b = {
                x: 0,
                y: 0,
                altX: 0,
                altY: 0
            }
        }
        b.x += d._x + g.x;
        b.altX += d._x + g.x;
        b.y += d._y + g.y;
        b.altY += d._y + g.y;
        h = d._verifyPosition(b, e, f, a);
        return new Sys.UI.Bounds(h.x,h.y,e,f)
    },
    _verifyPosition: function(a, f, e) {
        var c = 0
          , d = 0
          , b = this._getWindowBounds();
        if (!(a.x + f > b.x + b.width || a.x < b.x))
            c = a.x;
        else {
            c = a.altX;
            if (a.altX < b.x) {
                if (a.x > a.altX)
                    c = a.x
            } else if (b.width + b.x - a.altX < f) {
                var g = a.x > a.altX ? Math.abs(b.x - a.x) : b.x - a.x;
                if (g < f - b.width - b.x + a.altX)
                    c = a.x
            }
        }
        if (!(a.y + e > b.y + b.height || a.y < b.y))
            d = a.y;
        else {
            d = a.altY;
            if (a.altY < b.y) {
                if (b.y - a.altY > e - b.height - b.y + a.y)
                    d = a.y
            } else if (b.height + b.y - a.altY < e)
                if (b.y - a.y < e - b.height - b.y + a.altY)
                    d = a.y
        }
        return {
            x: c,
            y: d
        }
    },
    _getWindowBounds: function() {
        var a = this
          , b = {
            x: a._getWindowScrollLeft(),
            y: a._getWindowScrollTop(),
            width: a._getWindowWidth(),
            height: a._getWindowHeight()
        };
        return b
    },
    _getWindowHeight: function() {
        var a = 0;
        if (document.documentElement && document.documentElement.clientHeight)
            a = document.documentElement.clientHeight;
        else if (document.body && document.body.clientHeight)
            a = document.body.clientHeight;
        return a
    },
    _getWindowWidth: function() {
        var a = 0;
        if (document.documentElement && document.documentElement.clientWidth)
            a = document.documentElement.clientWidth;
        else if (document.body && document.body.clientWidth)
            a = document.body.clientWidth;
        return a
    },
    _getWindowScrollTop: function() {
        var a = 0;
        if (typeof window.pageYOffset == "number")
            a = window.pageYOffset;
        if (document.body && document.body.scrollTop)
            a = document.body.scrollTop;
        else if (document.documentElement && document.documentElement.scrollTop)
            a = document.documentElement.scrollTop;
        return a
    },
    _getWindowScrollLeft: function() {
        var a = 0;
        if (typeof window.pageXOffset == "number")
            a = window.pageXOffset;
        else if (document.body && document.body.scrollLeft)
            a = document.body.scrollLeft;
        else if (document.documentElement && document.documentElement.scrollLeft)
            a = document.documentElement.scrollLeft;
        return a
    },
    adjustPopupPosition: function(a) {
        var d = this.get_element();
        if (!a)
            a = this.getBounds();
        var b = $common.getBounds(d)
          , c = false;
        if (b.x < 0) {
            a.x -= b.x;
            c = true
        }
        if (b.y < 0) {
            a.y -= b.y;
            c = true
        }
        c && $common.setLocation(d, a)
    },
    addBackgroundIFrame: function() {
        var c = this
          , b = c.get_element();
        if (Sys.Browser.agent === Sys.Browser.InternetExplorer && Sys.Browser.version < 7) {
            var a = b._hideWindowedElementsIFrame;
            if (!a) {
                a = document.createElement("iframe");
                a.src = "javascript:'<html></html>';";
                a.style.position = "absolute";
                a.style.display = "none";
                a.scrolling = "no";
                a.frameBorder = "0";
                a.tabIndex = "-1";
                a.style.filter = "progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)";
                b.parentNode.insertBefore(a, b);
                b._hideWindowedElementsIFrame = a;
                c._moveHandler = Function.createDelegate(c, c._onMove);
                Sys.UI.DomEvent.addHandler(b, "move", c._moveHandler)
            }
            $common.setBounds(a, $common.getBounds(b));
            a.style.left = b.style.left;
            a.style.top = b.style.top;
            a.style.display = b.style.display;
            if (b.currentStyle && b.currentStyle.zIndex)
                a.style.zIndex = b.currentStyle.zIndex;
            else if (b.style.zIndex)
                a.style.zIndex = b.style.zIndex
        }
    },
    setupPopup: function() {
        var a = this
          , b = a.get_element()
          , c = a.getBounds();
        $common.setLocation(b, c);
        a.adjustPopupPosition(c);
        b.style.zIndex = 1e3;
        a.addBackgroundIFrame()
    },
    _hidePopup: function() {
        var a = this.get_element();
        $common.setVisible(a, false);
        if (a.originalWidth) {
            a.style.width = a.originalWidth + "px";
            a.originalWidth = null
        }
    },
    _hideCleanup: function() {
        var a = this
          , c = a.get_element();
        if (a._moveHandler) {
            Sys.UI.DomEvent.removeHandler(c, "move", a._moveHandler);
            a._moveHandler = null
        }
        if (Sys.Browser.agent === Sys.Browser.InternetExplorer) {
            var b = c._hideWindowedElementsIFrame;
            if (b)
                b.style.display = "none"
        }
        a.raiseHidden(Sys.EventArgs.Empty)
    },
    _onMove: function() {
        var a = this.get_element();
        if (a._hideWindowedElementsIFrame) {
            a.parentNode.insertBefore(a._hideWindowedElementsIFrame, a);
            a._hideWindowedElementsIFrame.style.top = a.style.top;
            a._hideWindowedElementsIFrame.style.left = a.style.left
        }
    },
    get_onShow: function() {
        return this._onShow ? this._onShow.get_json() : null
    },
    set_onShow: function(c) {
        var a = this;
        if (!a._onShow) {
            a._onShow = new AjaxControlToolkit.Animation.GenericAnimationBehavior(a.get_element());
            a._onShow.initialize()
        }
        a._onShow.set_json(c);
        var b = a._onShow.get_animation();
        b && b.add_ended(a._onShowEndedHandler);
        a.raisePropertyChanged("onShow")
    },
    get_onShowBehavior: function() {
        return this._onShow
    },
    onShow: function() {
        var a = this;
        if (a._onShow) {
            a._onHide && a._onHide.quit();
            a._onShow.play()
        }
    },
    _onShowEnded: function() {
        this.adjustPopupPosition();
        this.addBackgroundIFrame();
        this.raiseShown(Sys.EventArgs.Empty)
    },
    get_onHide: function() {
        return this._onHide ? this._onHide.get_json() : null
    },
    set_onHide: function(c) {
        var a = this;
        if (!a._onHide) {
            a._onHide = new AjaxControlToolkit.Animation.GenericAnimationBehavior(a.get_element());
            a._onHide.initialize()
        }
        a._onHide.set_json(c);
        var b = a._onHide.get_animation();
        b && b.add_ended(a._onHideEndedHandler);
        a.raisePropertyChanged("onHide")
    },
    get_onHideBehavior: function() {
        return this._onHide
    },
    onHide: function() {
        var a = this;
        if (a._onHide) {
            a._onShow && a._onShow.quit();
            a._onHide.play()
        }
    },
    _onHideEnded: function() {
        this._hideCleanup()
    },
    get_parentElement: function() {
        var a = this;
        if (!a._parentElement && a._parentElementID) {
            a.set_parentElement($get(a._parentElementID));
            Sys.Debug.assert(a._parentElement != null, String.format(AjaxControlToolkit.Resources.PopupExtender_NoParentElement, a._parentElementID))
        }
        return a._parentElement
    },
    set_parentElement: function(a) {
        this._parentElement = a;
        this.raisePropertyChanged("parentElement")
    },
    get_parentElementID: function() {
        if (this._parentElement)
            return this._parentElement.id;
        return this._parentElementID
    },
    set_parentElementID: function(a) {
        this._parentElementID = a;
        this.get_isInitialized() && this.set_parentElement($get(a))
    },
    get_positioningMode: function() {
        return this._positioningMode
    },
    set_positioningMode: function(a) {
        this._positioningMode = a;
        this.raisePropertyChanged("positioningMode")
    },
    get_x: function() {
        return this._x
    },
    set_x: function(b) {
        var a = this;
        if (b != a._x) {
            a._x = b;
            a._visible && a.setupPopup();
            a.raisePropertyChanged("x")
        }
    },
    get_y: function() {
        return this._y
    },
    set_y: function(b) {
        var a = this;
        if (b != a._y) {
            a._y = b;
            a._visible && a.setupPopup();
            a.raisePropertyChanged("y")
        }
    },
    get_visible: function() {
        return this._visible
    },
    add_showing: function(a) {
        this.get_events().addHandler("showing", a)
    },
    remove_showing: function(a) {
        this.get_events().removeHandler("showing", a)
    },
    raiseShowing: function(b) {
        var a = this.get_events().getHandler("showing");
        a && a(this, b)
    },
    add_shown: function(a) {
        this.get_events().addHandler("shown", a)
    },
    remove_shown: function(a) {
        this.get_events().removeHandler("shown", a)
    },
    raiseShown: function(b) {
        var a = this.get_events().getHandler("shown");
        a && a(this, b)
    },
    add_hiding: function(a) {
        this.get_events().addHandler("hiding", a)
    },
    remove_hiding: function(a) {
        this.get_events().removeHandler("hiding", a)
    },
    raiseHiding: function(b) {
        var a = this.get_events().getHandler("hiding");
        a && a(this, b)
    },
    add_hidden: function(a) {
        this.get_events().addHandler("hidden", a)
    },
    remove_hidden: function(a) {
        this.get_events().removeHandler("hidden", a)
    },
    raiseHidden: function(b) {
        var a = this.get_events().getHandler("hidden");
        a && a(this, b)
    }
};
AjaxControlToolkit.PopupBehavior.registerClass("AjaxControlToolkit.PopupBehavior", AjaxControlToolkit.BehaviorBase);
AjaxControlToolkit.PositioningMode = function() {
    throw Error.invalidOperation();
}
;
AjaxControlToolkit.PositioningMode.prototype = {
    Absolute: 0,
    Center: 1,
    BottomLeft: 2,
    BottomRight: 3,
    TopLeft: 4,
    TopRight: 5,
    Right: 6,
    Left: 7
};
AjaxControlToolkit.PositioningMode.registerEnum("AjaxControlToolkit.PositioningMode");
//END AjaxControlToolkit.PopupExtender.PopupBehavior.js
//START AjaxControlToolkit.Common.Threading.js
Type.registerNamespace("AjaxControlToolkit");
AjaxControlToolkit.DeferredOperation = function(e, d, c) {
    var b = null
      , a = this;
    a._delay = e;
    a._context = d;
    a._callback = c;
    a._completeCallback = b;
    a._errorCallback = b;
    a._timer = b;
    a._callArgs = b;
    a._isComplete = false;
    a._completedSynchronously = false;
    a._asyncResult = b;
    a._exception = b;
    a._throwExceptions = true;
    a._oncomplete$delegate = Function.createDelegate(a, a._oncomplete);
    a.post = Function.createDelegate(a, a.post)
}
;
AjaxControlToolkit.DeferredOperation.prototype = {
    get_isPending: function() {
        return this._timer != null
    },
    get_isComplete: function() {
        return this._isComplete
    },
    get_completedSynchronously: function() {
        return this._completedSynchronously
    },
    get_exception: function() {
        return this._exception
    },
    get_throwExceptions: function() {
        return this._throwExceptions
    },
    set_throwExceptions: function(a) {
        this._throwExceptions = a
    },
    get_delay: function() {
        return this._delay
    },
    set_delay: function(a) {
        this._delay = a
    },
    post: function() {
        for (var b = [], a = 0; a < arguments.length; a++)
            b[a] = arguments[a];
        this.beginPost(b, null, null)
    },
    beginPost: function(d, b, c) {
        var a = this;
        a.cancel();
        a._callArgs = Array.clone(d || []);
        a._completeCallback = b;
        a._errorCallback = c;
        if (a._delay == -1)
            try {
                a._oncomplete()
            } finally {
                a._completedSynchronously = true
            }
        else
            a._timer = setTimeout(a._oncomplete$delegate, a._delay)
    },
    cancel: function() {
        var b = null
          , a = this;
        if (a._timer) {
            clearTimeout(a._timer);
            a._timer = b
        }
        a._callArgs = b;
        a._isComplete = false;
        a._asyncResult = b;
        a._completeCallback = b;
        a._errorCallback = b;
        a._exception = b;
        a._completedSynchronously = false
    },
    call: function() {
        var a = this;
        for (var c = [], b = 0; b < arguments.length; b++)
            c[b] = arguments[b];
        a.cancel();
        a._callArgs = c;
        a._completeCallback = null;
        a._errorCallback = null;
        try {
            a._oncomplete()
        } finally {
            a._completedSynchronously = true
        }
        if (a._exception)
            throw a._exception;
        return a._asyncResult
    },
    complete: function() {
        var a = this;
        if (a._timer) {
            try {
                a._oncomplete()
            } finally {
                a._completedSynchronously = true
            }
            return a._asyncResult
        } else if (a._isComplete)
            return a._asyncResult
    },
    _oncomplete: function() {
        var a = this
          , d = a._callArgs
          , b = a._completeCallback
          , c = a._errorCallback;
        a.cancel();
        try {
            if (d)
                a._asyncResult = a._callback.apply(a._context, d);
            else
                a._asyncResult = a._callback.call(a._context);
            a._isComplete = true;
            a._completedSynchronously = false;
            b && b(a)
        } catch (e) {
            a._isComplete = true;
            a._completedSynchronously = false;
            a._exception = e;
            if (c)
                if (c(a))
                    return;
            if (a._throwExceptions)
                throw e;
        }
    }
};
AjaxControlToolkit.DeferredOperation.registerClass("AjaxControlToolkit.DeferredOperation");
//END AjaxControlToolkit.Common.Threading.js
//START AjaxControlToolkit.Calendar.CalendarBehavior.js
Type.registerNamespace("AjaxControlToolkit");
AjaxControlToolkit.CalendarBehavior = function(d) {
    var c = false
      , b = null
      , a = this;
    AjaxControlToolkit.CalendarBehavior.initializeBase(a, [d]);
    a._textbox = AjaxControlToolkit.TextBoxWrapper.get_Wrapper(d);
    a._format = "d";
    a._todaysDateFormat = "MMMM d, yyyy";
    a._daysModeTitleFormat = "MMMM, yyyy";
    a._cssClass = "ajax__calendar";
    a._enabled = true;
    a._animated = true;
    a._buttonID = b;
    a._layoutRequested = 0;
    a._layoutSuspended = c;
    a._button = b;
    a._popupMouseDown = c;
    a._selectedDate = b;
    a._visibleDate = b;
    a._todaysDate = b;
    a._firstDayOfWeek = AjaxControlToolkit.FirstDayOfWeek.Default;
    a._firstPopUp = true;
    a._container = b;
    a._popupDiv = b;
    a._header = b;
    a._prevArrow = b;
    a._nextArrow = b;
    a._title = b;
    a._body = b;
    a._today = b;
    a._days = b;
    a._daysTable = b;
    a._daysTableHeader = b;
    a._daysTableHeaderRow = b;
    a._daysBody = b;
    a._months = b;
    a._monthsTable = b;
    a._monthsBody = b;
    a._years = b;
    a._yearsTable = b;
    a._yearsBody = b;
    a._popupPosition = AjaxControlToolkit.CalendarPosition.BottomLeft;
    a._defaultView = AjaxControlToolkit.CalendarDefaultView.Days;
    a._popupBehavior = b;
    a._modeChangeAnimation = b;
    a._modeChangeMoveTopOrLeftAnimation = b;
    a._modeChangeMoveBottomOrRightAnimation = b;
    a._mode = "days";
    a._selectedDateChanging = c;
    a._isOpen = c;
    a._isAnimating = c;
    a._clearTime = c;
    a._width = 170;
    a._height = 139;
    a._modes = {
        days: b,
        months: b,
        years: b
    };
    a._modeOrder = {
        days: 0,
        months: 1,
        years: 2
    };
    a._hourOffsetForDst = 12;
    a._blur = new AjaxControlToolkit.DeferredOperation(1,a,a.blur);
    a._button$delegates = {
        click: Function.createDelegate(a, a._button_onclick),
        keypress: Function.createDelegate(a, a._button_onkeypress),
        blur: Function.createDelegate(a, a._button_onblur)
    };
    a._element$delegates = {
        change: Function.createDelegate(a, a._element_onchange),
        keypress: Function.createDelegate(a, a._element_onkeypress),
        click: Function.createDelegate(a, a._element_onclick),
        focus: Function.createDelegate(a, a._element_onfocus),
        blur: Function.createDelegate(a, a._element_onblur)
    };
    a._popup$delegates = {
        mousedown: Function.createDelegate(a, a._popup_onmousedown),
        mouseup: Function.createDelegate(a, a._popup_onmouseup),
        drag: Function.createDelegate(a, a._popup_onevent),
        dragstart: Function.createDelegate(a, a._popup_onevent),
        select: Function.createDelegate(a, a._popup_onevent)
    };
    a._cell$delegates = {
        mouseover: Function.createDelegate(a, a._cell_onmouseover),
        mouseout: Function.createDelegate(a, a._cell_onmouseout),
        click: Function.createDelegate(a, a._cell_onclick)
    }
}
;
AjaxControlToolkit.CalendarBehavior.prototype = {
    get_clearTime: function() {
        return this._clearTime
    },
    set_clearTime: function(a) {
        if (this._clearTime != a) {
            this._clearTime = a;
            this.raisePropertyChanged("_clearTime")
        }
    },
    get_animated: function() {
        return this._animated
    },
    set_animated: function(a) {
        if (this._animated != a) {
            this._animated = a;
            this.raisePropertyChanged("animated")
        }
    },
    get_enabled: function() {
        return this._enabled
    },
    set_enabled: function(a) {
        if (this._enabled != a) {
            this._enabled = a;
            this.raisePropertyChanged("enabled")
        }
    },
    get_button: function() {
        return this._button
    },
    set_button: function(b) {
        var a = this;
        if (a._button != b) {
            a._button && a.get_isInitialized() && $common.removeHandlers(a._button, a._button$delegates);
            a._button = b;
            a._button && a.get_isInitialized() && $addHandlers(a._button, a._button$delegates);
            a.raisePropertyChanged("button")
        }
    },
    get_popupPosition: function() {
        return this._popupPosition
    },
    set_popupPosition: function(a) {
        if (this._popupPosition != a) {
            this._popupPosition = a;
            this.raisePropertyChanged("popupPosition")
        }
    },
    get_format: function() {
        return this._format
    },
    set_format: function(a) {
        if (this._format != a) {
            this._format = a;
            this.raisePropertyChanged("format")
        }
    },
    get_todaysDateFormat: function() {
        return this._todaysDateFormat
    },
    set_todaysDateFormat: function(a) {
        if (this._todaysDateFormat != a) {
            this._todaysDateFormat = a;
            this.raisePropertyChanged("todaysDateFormat")
        }
    },
    get_daysModeTitleFormat: function() {
        return this._daysModeTitleFormat
    },
    set_daysModeTitleFormat: function(a) {
        if (this._daysModeTitleFormat != a) {
            this._daysModeTitleFormat = a;
            this.raisePropertyChanged("daysModeTitleFormat")
        }
    },
    get_selectedDate: function() {
        var a = this;
        if (a._selectedDate == null) {
            var b = a._textbox.get_Value();
            if (b) {
                b = a._parseTextValue(b);
                if (b)
                    a._selectedDate = b.getDateOnly()
            }
        }
        return a._selectedDate
    },
    set_selectedDate: function(b) {
        var a = this;
        if (b && String.isInstanceOfType(b) && b.length != 0)
            b = new Date(b);
        if (b)
            b = b.getDateOnly();
        if (a._selectedDate != b) {
            a._selectedDate = b;
            a._selectedDateChanging = true;
            var d = "";
            if (b) {
                d = b.localeFormat(a._format);
                if (!a._clearTime) {
                    var c = a._textbox.get_Value();
                    if (c)
                        c = a._parseTextValue(c);
                    if (c)
                        if (b != c.getDateOnly())
                            d = b.add(c.getTimeOfDay()).localeFormat(a._format)
                }
            }
            if (d != a._textbox.get_Value()) {
                a._textbox.set_Value(d);
                a._fireChanged()
            }
            a._selectedDateChanging = false;
            a.invalidate();
            a.raisePropertyChanged("selectedDate")
        }
    },
    get_defaultView: function() {
        return this._defaultView
    },
    set_defaultView: function(a) {
        if (this._defaultView != a) {
            this._defaultView = a;
            this.raisePropertyChanged("defaultView")
        }
    },
    get_visibleDate: function() {
        return this._visibleDate
    },
    set_visibleDate: function(a) {
        var b = this;
        if (a)
            a = a.getDateOnly();
        if (b._visibleDate != a) {
            b._switchMonth(a, !b._isOpen);
            b.raisePropertyChanged("visibleDate")
        }
    },
    get_isOpen: function() {
        return this._isOpen
    },
    get_todaysDate: function() {
        if (this._todaysDate != null)
            return this._todaysDate;
        return (new Date).getDateOnly()
    },
    set_todaysDate: function(a) {
        var b = this;
        if (a)
            a = a.getDateOnly();
        if (b._todaysDate != a) {
            b._todaysDate = a;
            b.invalidate();
            b.raisePropertyChanged("todaysDate")
        }
    },
    get_firstDayOfWeek: function() {
        return this._firstDayOfWeek
    },
    set_firstDayOfWeek: function(b) {
        var a = this;
        if (a._firstDayOfWeek != b) {
            a._firstDayOfWeek = b;
            a.invalidate();
            a.raisePropertyChanged("firstDayOfWeek")
        }
    },
    get_cssClass: function() {
        return this._cssClass
    },
    set_cssClass: function(b) {
        var a = this;
        if (a._cssClass != b) {
            a._cssClass && a.get_isInitialized() && Sys.UI.DomElement.removeCssClass(a._container, a._cssClass);
            a._cssClass = b;
            a._cssClass && a.get_isInitialized() && Sys.UI.DomElement.addCssClass(a._container, a._cssClass);
            a.raisePropertyChanged("cssClass")
        }
    },
    get_todayButton: function() {
        return this._today
    },
    get_dayCell: function(b, a) {
        if (this._daysBody)
            return this._daysBody.rows[b].cells[a].firstChild;
        return null
    },
    add_showing: function(a) {
        this.get_events().addHandler("showing", a)
    },
    remove_showing: function(a) {
        this.get_events().removeHandler("showing", a)
    },
    raiseShowing: function(b) {
        var a = this.get_events().getHandler("showing");
        a && a(this, b)
    },
    add_shown: function(a) {
        this.get_events().addHandler("shown", a)
    },
    remove_shown: function(a) {
        this.get_events().removeHandler("shown", a)
    },
    raiseShown: function() {
        var a = this.get_events().getHandler("shown");
        a && a(this, Sys.EventArgs.Empty)
    },
    add_hiding: function(a) {
        this.get_events().addHandler("hiding", a)
    },
    remove_hiding: function(a) {
        this.get_events().removeHandler("hiding", a)
    },
    raiseHiding: function(b) {
        var a = this.get_events().getHandler("hiding");
        a && a(this, b)
    },
    add_hidden: function(a) {
        this.get_events().addHandler("hidden", a)
    },
    remove_hidden: function(a) {
        this.get_events().removeHandler("hidden", a)
    },
    raiseHidden: function() {
        var a = this.get_events().getHandler("hidden");
        a && a(this, Sys.EventArgs.Empty)
    },
    add_dateSelectionChanged: function(a) {
        this.get_events().addHandler("dateSelectionChanged", a)
    },
    remove_dateSelectionChanged: function(a) {
        this.get_events().removeHandler("dateSelectionChanged", a)
    },
    raiseDateSelectionChanged: function() {
        var a = this.get_events().getHandler("dateSelectionChanged");
        a && a(this, Sys.EventArgs.Empty)
    },
    initialize: function() {
        var b = null
          , a = this;
        AjaxControlToolkit.CalendarBehavior.callBaseMethod(a, "initialize");
        var d = a.get_element();
        $addHandlers(d, a._element$delegates);
        a._button && $addHandlers(a._button, a._button$delegates);
        a._modeChangeMoveTopOrLeftAnimation = new AjaxControlToolkit.Animation.LengthAnimation(b,b,b,"style",b,0,0,"px");
        a._modeChangeMoveBottomOrRightAnimation = new AjaxControlToolkit.Animation.LengthAnimation(b,b,b,"style",b,0,0,"px");
        a._modeChangeAnimation = new AjaxControlToolkit.Animation.ParallelAnimation(b,.25,b,[a._modeChangeMoveTopOrLeftAnimation, a._modeChangeMoveBottomOrRightAnimation]);
        var c = a.get_selectedDate();
        c && a.set_selectedDate(c)
    },
    dispose: function() {
        var b = null
          , a = this;
        if (a._popupBehavior) {
            a._popupBehavior.dispose();
            a._popupBehavior = b
        }
        a._modes = b;
        a._modeOrder = b;
        if (a._modeChangeMoveTopOrLeftAnimation) {
            a._modeChangeMoveTopOrLeftAnimation.dispose();
            a._modeChangeMoveTopOrLeftAnimation = b
        }
        if (a._modeChangeMoveBottomOrRightAnimation) {
            a._modeChangeMoveBottomOrRightAnimation.dispose();
            a._modeChangeMoveBottomOrRightAnimation = b
        }
        if (a._modeChangeAnimation) {
            a._modeChangeAnimation.dispose();
            a._modeChangeAnimation = b
        }
        if (a._container) {
            a._container.parentNode && a._container.parentNode.removeChild(a._container);
            a._container = b
        }
        if (a._popupDiv) {
            $common.removeHandlers(a._popupDiv, a._popup$delegates);
            a._popupDiv = b
        }
        if (a._prevArrow) {
            $common.removeHandlers(a._prevArrow, a._cell$delegates);
            a._prevArrow = b
        }
        if (a._nextArrow) {
            $common.removeHandlers(a._nextArrow, a._cell$delegates);
            a._nextArrow = b
        }
        if (a._title) {
            $common.removeHandlers(a._title, a._cell$delegates);
            a._title = b
        }
        if (a._today) {
            $common.removeHandlers(a._today, a._cell$delegates);
            a._today = b
        }
        if (a._button) {
            $common.removeHandlers(a._button, a._button$delegates);
            a._button = b
        }
        if (a._daysBody) {
            for (var c = 0; c < a._daysBody.rows.length; c++)
                for (var e = a._daysBody.rows[c], d = 0; d < e.cells.length; d++)
                    $common.removeHandlers(e.cells[d].firstChild, a._cell$delegates);
            a._daysBody = b
        }
        if (a._monthsBody) {
            for (var c = 0; c < a._monthsBody.rows.length; c++)
                for (var e = a._monthsBody.rows[c], d = 0; d < e.cells.length; d++)
                    $common.removeHandlers(e.cells[d].firstChild, a._cell$delegates);
            a._monthsBody = b
        }
        if (a._yearsBody) {
            for (var c = 0; c < a._yearsBody.rows.length; c++)
                for (var e = a._yearsBody.rows[c], d = 0; d < e.cells.length; d++)
                    $common.removeHandlers(e.cells[d].firstChild, a._cell$delegates);
            a._yearsBody = b
        }
        var f = a.get_element();
        $common.removeHandlers(f, a._element$delegates);
        AjaxControlToolkit.CalendarBehavior.callBaseMethod(a, "dispose")
    },
    show: function() {
        var b = true
          , a = this;
        a._ensureCalendar();
        if (!a._isOpen) {
            var c = new Sys.CancelEventArgs;
            a.raiseShowing(c);
            if (c.get_cancel())
                return;
            a._isOpen = b;
            a._popupBehavior.show();
            if (a._firstPopUp) {
                a._switchMonth(null, b);
                switch (a._defaultView) {
                case AjaxControlToolkit.CalendarDefaultView.Months:
                    a._switchMode("months", b);
                    break;
                case AjaxControlToolkit.CalendarDefaultView.Years:
                    a._switchMode("years", b)
                }
                a._firstPopUp = false
            }
            a.raiseShown()
        }
    },
    hide: function() {
        var a = this;
        if (a._isOpen) {
            var b = new Sys.CancelEventArgs;
            a.raiseHiding(b);
            if (b.get_cancel())
                return;
            a._container && a._popupBehavior.hide();
            a._isOpen = false;
            a.raiseHidden();
            a._popupMouseDown = false
        }
    },
    focus: function() {
        if (this._button)
            this._button.focus();
        else
            this.get_element().focus()
    },
    blur: function(b) {
        var a = this;
        if (!b && Sys.Browser.agent === Sys.Browser.Opera)
            a._blur.post(true);
        else {
            !a._popupMouseDown && a.hide();
            a._popupMouseDown = false
        }
    },
    suspendLayout: function() {
        this._layoutSuspended++
    },
    resumeLayout: function() {
        var a = this;
        a._layoutSuspended--;
        if (a._layoutSuspended <= 0) {
            a._layoutSuspended = 0;
            a._layoutRequested && a._performLayout()
        }
    },
    invalidate: function() {
        if (this._layoutSuspended > 0)
            this._layoutRequested = true;
        else
            this._performLayout()
    },
    _buildCalendar: function() {
        var a = this
          , c = a.get_element()
          , b = a.get_id();
        a._container = $common.createElementFromTemplate({
            nodeName: "div",
            properties: {
                id: b + "_container"
            },
            cssClasses: [a._cssClass],
            visible: false
        }, c.parentNode);
        a._popupDiv = $common.createElementFromTemplate({
            nodeName: "div",
            events: a._popup$delegates,
            properties: {
                id: b + "_popupDiv"
            },
            cssClasses: ["ajax__calendar_container"]
        }, a._container)
    },
    _buildHeader: function() {
        var b = "div"
          , a = this
          , c = a.get_id();
        a._header = $common.createElementFromTemplate({
            nodeName: b,
            properties: {
                id: c + "_header"
            },
            cssClasses: ["ajax__calendar_header"]
        }, a._popupDiv);
        var e = $common.createElementFromTemplate({
            nodeName: b
        }, a._header);
        a._prevArrow = $common.createElementFromTemplate({
            nodeName: b,
            properties: {
                id: c + "_prevArrow",
                mode: "prev"
            },
            events: a._cell$delegates,
            cssClasses: ["ajax__calendar_prev"]
        }, e);
        var d = $common.createElementFromTemplate({
            nodeName: b
        }, a._header);
        a._nextArrow = $common.createElementFromTemplate({
            nodeName: b,
            properties: {
                id: c + "_nextArrow",
                mode: "next"
            },
            events: a._cell$delegates,
            cssClasses: ["ajax__calendar_next"]
        }, d);
        var f = $common.createElementFromTemplate({
            nodeName: b
        }, a._header);
        a._title = $common.createElementFromTemplate({
            nodeName: b,
            properties: {
                id: c + "_title",
                mode: "title"
            },
            events: a._cell$delegates,
            cssClasses: ["ajax__calendar_title"]
        }, f)
    },
    _buildBody: function() {
        var a = this;
        a._body = $common.createElementFromTemplate({
            nodeName: "div",
            properties: {
                id: a.get_id() + "_body"
            },
            cssClasses: ["ajax__calendar_body"]
        }, a._popupDiv);
        a._buildDays();
        a._buildMonths();
        a._buildYears()
    },
    _buildFooter: function() {
        var a = this
          , b = $common.createElementFromTemplate({
            nodeName: "div"
        }, a._popupDiv);
        a._today = $common.createElementFromTemplate({
            nodeName: "div",
            properties: {
                id: a.get_id() + "_today",
                mode: "today"
            },
            events: a._cell$delegates,
            cssClasses: ["ajax__calendar_footer", "ajax__calendar_today"]
        }, b)
    },
    _buildDays: function() {
        var a = this
          , h = Sys.CultureInfo.CurrentCulture.dateTimeFormat
          , b = a.get_id();
        a._days = $common.createElementFromTemplate({
            nodeName: "div",
            properties: {
                id: b + "_days"
            },
            cssClasses: ["ajax__calendar_days"]
        }, a._body);
        a._modes["days"] = a._days;
        a._daysTable = $common.createElementFromTemplate({
            nodeName: "table",
            properties: {
                id: b + "_daysTable",
                cellPadding: 0,
                cellSpacing: 0,
                border: 0,
                style: {
                    margin: "auto"
                }
            }
        }, a._days);
        a._daysTableHeader = $common.createElementFromTemplate({
            nodeName: "thead",
            properties: {
                id: b + "_daysTableHeader"
            }
        }, a._daysTable);
        a._daysTableHeaderRow = $common.createElementFromTemplate({
            nodeName: "tr",
            properties: {
                id: b + "_daysTableHeaderRow"
            }
        }, a._daysTableHeader);
        for (var c = 0; c < 7; c++)
            var e = $common.createElementFromTemplate({
                nodeName: "td"
            }, a._daysTableHeaderRow)
              , g = $common.createElementFromTemplate({
                nodeName: "div",
                cssClasses: ["ajax__calendar_dayname"]
            }, e);
        a._daysBody = $common.createElementFromTemplate({
            nodeName: "tbody",
            properties: {
                id: b + "_daysBody"
            }
        }, a._daysTable);
        for (var c = 0; c < 6; c++)
            for (var f = $common.createElementFromTemplate({
                nodeName: "tr"
            }, a._daysBody), d = 0; d < 7; d++)
                var e = $common.createElementFromTemplate({
                    nodeName: "td"
                }, f)
                  , g = $common.createElementFromTemplate({
                    nodeName: "div",
                    properties: {
                        mode: "day",
                        id: b + "_day_" + c + "_" + d,
                        innerHTML: "&nbsp;"
                    },
                    events: a._cell$delegates,
                    cssClasses: ["ajax__calendar_day"]
                }, e)
    },
    _buildMonths: function() {
        var a = this
          , g = Sys.CultureInfo.CurrentCulture.dateTimeFormat
          , d = a.get_id();
        a._months = $common.createElementFromTemplate({
            nodeName: "div",
            properties: {
                id: d + "_months"
            },
            cssClasses: ["ajax__calendar_months"],
            visible: false
        }, a._body);
        a._modes["months"] = a._months;
        a._monthsTable = $common.createElementFromTemplate({
            nodeName: "table",
            properties: {
                id: d + "_monthsTable",
                cellPadding: 0,
                cellSpacing: 0,
                border: 0,
                style: {
                    margin: "auto"
                }
            }
        }, a._months);
        a._monthsBody = $common.createElementFromTemplate({
            nodeName: "tbody",
            properties: {
                id: d + "_monthsBody"
            }
        }, a._monthsTable);
        for (var b = 0; b < 3; b++)
            for (var f = $common.createElementFromTemplate({
                nodeName: "tr"
            }, a._monthsBody), c = 0; c < 4; c++)
                var e = $common.createElementFromTemplate({
                    nodeName: "td"
                }, f)
                  , h = $common.createElementFromTemplate({
                    nodeName: "div",
                    properties: {
                        id: d + "_month_" + b + "_" + c,
                        mode: "month",
                        month: b * 4 + c,
                        innerHTML: "<br />" + g.AbbreviatedMonthNames[b * 4 + c]
                    },
                    events: a._cell$delegates,
                    cssClasses: ["ajax__calendar_month"]
                }, e)
    },
    _buildYears: function() {
        var a = this
          , b = a.get_id();
        a._years = $common.createElementFromTemplate({
            nodeName: "div",
            properties: {
                id: b + "_years"
            },
            cssClasses: ["ajax__calendar_years"],
            visible: false
        }, a._body);
        a._modes["years"] = a._years;
        a._yearsTable = $common.createElementFromTemplate({
            nodeName: "table",
            properties: {
                id: b + "_yearsTable",
                cellPadding: 0,
                cellSpacing: 0,
                border: 0,
                style: {
                    margin: "auto"
                }
            }
        }, a._years);
        a._yearsBody = $common.createElementFromTemplate({
            nodeName: "tbody",
            properties: {
                id: b + "_yearsBody"
            }
        }, a._yearsTable);
        for (var c = 0; c < 3; c++)
            for (var f = $common.createElementFromTemplate({
                nodeName: "tr"
            }, a._yearsBody), d = 0; d < 4; d++)
                var e = $common.createElementFromTemplate({
                    nodeName: "td"
                }, f)
                  , g = $common.createElementFromTemplate({
                    nodeName: "div",
                    properties: {
                        id: b + "_year_" + c + "_" + d,
                        mode: "year",
                        year: c * 4 + d - 1
                    },
                    events: a._cell$delegates,
                    cssClasses: ["ajax__calendar_year"]
                }, e)
    },
    _performLayout: function() {
        var l = "ajax__calendar_active"
          , k = "ajax__calendar_other"
          , a = this
          , t = a.get_element();
        if (!t)
            return;
        if (!a.get_isInitialized())
            return;
        if (!a._isOpen)
            return;
        var s = Sys.CultureInfo.CurrentCulture.dateTimeFormat
          , u = a.get_selectedDate()
          , c = a._getEffectiveVisibleDate()
          , p = a.get_todaysDate();
        switch (a._mode) {
        case "days":
            var o = a._getFirstDayOfWeek()
              , j = c.getDay() - o;
            if (j <= 0)
                j += 7;
            for (var q = new Date(c.getFullYear(),c.getMonth(),c.getDate() - j,a._hourOffsetForDst), f = q, e = 0; e < 7; e++) {
                var d = a._daysTableHeaderRow.cells[e].firstChild;
                d.firstChild && d.removeChild(d.firstChild);
                d.appendChild(document.createTextNode(s.ShortestDayNames[(e + o) % 7]))
            }
            for (var n = 0; n < 6; n++)
                for (var r = a._daysBody.rows[n], m = 0; m < 7; m++) {
                    var d = r.cells[m].firstChild;
                    d.firstChild && d.removeChild(d.firstChild);
                    d.appendChild(document.createTextNode(f.getDate()));
                    d.title = f.localeFormat("D");
                    d.date = f;
                    $common.removeCssClasses(d.parentNode, [k, l]);
                    Sys.UI.DomElement.addCssClass(d.parentNode, a._getCssClass(d.date, "d"));
                    f = new Date(f.getFullYear(),f.getMonth(),f.getDate() + 1,a._hourOffsetForDst)
                }
            a._prevArrow.date = new Date(c.getFullYear(),c.getMonth() - 1,1,a._hourOffsetForDst);
            a._nextArrow.date = new Date(c.getFullYear(),c.getMonth() + 1,1,a._hourOffsetForDst);
            a._title.firstChild && a._title.removeChild(a._title.firstChild);
            a._title.appendChild(document.createTextNode(c.localeFormat(a.get_daysModeTitleFormat())));
            a._title.date = c;
            break;
        case "months":
            for (var e = 0; e < a._monthsBody.rows.length; e++)
                for (var i = a._monthsBody.rows[e], h = 0; h < i.cells.length; h++) {
                    var b = i.cells[h].firstChild;
                    b.date = new Date(c.getFullYear(),b.month,1,a._hourOffsetForDst);
                    b.title = b.date.localeFormat("Y");
                    $common.removeCssClasses(b.parentNode, [k, l]);
                    Sys.UI.DomElement.addCssClass(b.parentNode, a._getCssClass(b.date, "M"))
                }
            a._title.firstChild && a._title.removeChild(a._title.firstChild);
            a._title.appendChild(document.createTextNode(c.localeFormat("yyyy")));
            a._title.date = c;
            a._prevArrow.date = new Date(c.getFullYear() - 1,0,1,a._hourOffsetForDst);
            a._nextArrow.date = new Date(c.getFullYear() + 1,0,1,a._hourOffsetForDst);
            break;
        case "years":
            for (var g = Math.floor(c.getFullYear() / 10) * 10, e = 0; e < a._yearsBody.rows.length; e++)
                for (var i = a._yearsBody.rows[e], h = 0; h < i.cells.length; h++) {
                    var b = i.cells[h].firstChild;
                    b.date = new Date(g + b.year,0,1,a._hourOffsetForDst);
                    if (b.firstChild)
                        b.removeChild(b.lastChild);
                    else
                        b.appendChild(document.createElement("br"));
                    b.appendChild(document.createTextNode(g + b.year));
                    $common.removeCssClasses(b.parentNode, [k, l]);
                    Sys.UI.DomElement.addCssClass(b.parentNode, a._getCssClass(b.date, "y"))
                }
            a._title.firstChild && a._title.removeChild(a._title.firstChild);
            a._title.appendChild(document.createTextNode(g.toString() + "-" + (g + 9).toString()));
            a._title.date = c;
            a._prevArrow.date = new Date(g - 10,0,1,a._hourOffsetForDst);
            a._nextArrow.date = new Date(g + 10,0,1,a._hourOffsetForDst)
        }
        a._today.firstChild && a._today.removeChild(a._today.firstChild);
        a._today.appendChild(document.createTextNode(String.format(AjaxControlToolkit.Resources.Calendar_Today, p.localeFormat(a.get_todaysDateFormat()))));
        a._today.date = p
    },
    _ensureCalendar: function() {
        var a = this;
        if (!a._container) {
            var b = a.get_element();
            a._buildCalendar();
            a._buildHeader();
            a._buildBody();
            a._buildFooter();
            a._popupBehavior = new $create(AjaxControlToolkit.PopupBehavior,{
                parentElement: b
            },{},{},a._container);
            if (a._popupPosition == AjaxControlToolkit.CalendarPosition.TopLeft)
                a._popupBehavior.set_positioningMode(AjaxControlToolkit.PositioningMode.TopLeft);
            else if (a._popupPosition == AjaxControlToolkit.CalendarPosition.TopRight)
                a._popupBehavior.set_positioningMode(AjaxControlToolkit.PositioningMode.TopRight);
            else if (a._popupPosition == AjaxControlToolkit.CalendarPosition.BottomRight)
                a._popupBehavior.set_positioningMode(AjaxControlToolkit.PositioningMode.BottomRight);
            else if (a._popupPosition == AjaxControlToolkit.CalendarPosition.Right)
                a._popupBehavior.set_positioningMode(AjaxControlToolkit.PositioningMode.Right);
            else if (a._popupPosition == AjaxControlToolkit.CalendarPosition.Left)
                a._popupBehavior.set_positioningMode(AjaxControlToolkit.PositioningMode.Left);
            else
                a._popupBehavior.set_positioningMode(AjaxControlToolkit.PositioningMode.BottomLeft)
        }
    },
    _fireChanged: function() {
        var a = this.get_element();
        if (document.createEventObject)
            a.fireEvent("onchange");
        else if (document.createEvent) {
            var b = document.createEvent("HTMLEvents");
            b.initEvent("change", true, true);
            a.dispatchEvent(b)
        }
    },
    _switchMonth: function(e, h) {
        var f = "left"
          , c = true
          , a = this;
        if (a._isAnimating)
            return;
        var g = a._getEffectiveVisibleDate();
        if (e && e.getFullYear() == g.getFullYear() && e.getMonth() == g.getMonth())
            h = c;
        if (a._animated && !h) {
            a._isAnimating = c;
            var d = a._modes[a._mode]
              , b = d.cloneNode(c);
            a._body.appendChild(b);
            if (g > e) {
                $common.setLocation(d, {
                    x: -162,
                    y: 0
                });
                $common.setVisible(d, c);
                a._modeChangeMoveTopOrLeftAnimation.set_propertyKey(f);
                a._modeChangeMoveTopOrLeftAnimation.set_target(d);
                a._modeChangeMoveTopOrLeftAnimation.set_startValue(-a._width);
                a._modeChangeMoveTopOrLeftAnimation.set_endValue(0);
                $common.setLocation(b, {
                    x: 0,
                    y: 0
                });
                $common.setVisible(b, c);
                a._modeChangeMoveBottomOrRightAnimation.set_propertyKey(f);
                a._modeChangeMoveBottomOrRightAnimation.set_target(b);
                a._modeChangeMoveBottomOrRightAnimation.set_startValue(0);
                a._modeChangeMoveBottomOrRightAnimation.set_endValue(a._width)
            } else {
                $common.setLocation(b, {
                    x: 0,
                    y: 0
                });
                $common.setVisible(b, c);
                a._modeChangeMoveTopOrLeftAnimation.set_propertyKey(f);
                a._modeChangeMoveTopOrLeftAnimation.set_target(b);
                a._modeChangeMoveTopOrLeftAnimation.set_endValue(-a._width);
                a._modeChangeMoveTopOrLeftAnimation.set_startValue(0);
                $common.setLocation(d, {
                    x: 162,
                    y: 0
                });
                $common.setVisible(d, c);
                a._modeChangeMoveBottomOrRightAnimation.set_propertyKey(f);
                a._modeChangeMoveBottomOrRightAnimation.set_target(d);
                a._modeChangeMoveBottomOrRightAnimation.set_endValue(0);
                a._modeChangeMoveBottomOrRightAnimation.set_startValue(a._width)
            }
            a._visibleDate = e;
            a.invalidate();
            var i = Function.createDelegate(a, function() {
                this._body.removeChild(b);
                b = null;
                this._isAnimating = false;
                this._modeChangeAnimation.remove_ended(i)
            });
            a._modeChangeAnimation.add_ended(i);
            a._modeChangeAnimation.play()
        } else {
            a._visibleDate = e;
            a.invalidate()
        }
    },
    _switchMode: function(e, h) {
        var f = "top"
          , d = true
          , a = this;
        if (a._isAnimating || a._mode == e)
            return;
        var i = a._modeOrder[a._mode] < a._modeOrder[e]
          , c = a._modes[a._mode]
          , b = a._modes[e];
        a._mode = e;
        if (a._animated && !h) {
            a._isAnimating = d;
            a.invalidate();
            if (i) {
                $common.setLocation(b, {
                    x: 0,
                    y: -a._height
                });
                $common.setVisible(b, d);
                a._modeChangeMoveTopOrLeftAnimation.set_propertyKey(f);
                a._modeChangeMoveTopOrLeftAnimation.set_target(b);
                a._modeChangeMoveTopOrLeftAnimation.set_startValue(-a._height);
                a._modeChangeMoveTopOrLeftAnimation.set_endValue(0);
                $common.setLocation(c, {
                    x: 0,
                    y: 0
                });
                $common.setVisible(c, d);
                a._modeChangeMoveBottomOrRightAnimation.set_propertyKey(f);
                a._modeChangeMoveBottomOrRightAnimation.set_target(c);
                a._modeChangeMoveBottomOrRightAnimation.set_startValue(0);
                a._modeChangeMoveBottomOrRightAnimation.set_endValue(a._height)
            } else {
                $common.setLocation(c, {
                    x: 0,
                    y: 0
                });
                $common.setVisible(c, d);
                a._modeChangeMoveTopOrLeftAnimation.set_propertyKey(f);
                a._modeChangeMoveTopOrLeftAnimation.set_target(c);
                a._modeChangeMoveTopOrLeftAnimation.set_endValue(-a._height);
                a._modeChangeMoveTopOrLeftAnimation.set_startValue(0);
                $common.setLocation(b, {
                    x: 0,
                    y: 139
                });
                $common.setVisible(b, d);
                a._modeChangeMoveBottomOrRightAnimation.set_propertyKey(f);
                a._modeChangeMoveBottomOrRightAnimation.set_target(b);
                a._modeChangeMoveBottomOrRightAnimation.set_endValue(0);
                a._modeChangeMoveBottomOrRightAnimation.set_startValue(a._height)
            }
            var g = Function.createDelegate(a, function() {
                this._isAnimating = false;
                this._modeChangeAnimation.remove_ended(g)
            });
            a._modeChangeAnimation.add_ended(g);
            a._modeChangeAnimation.play()
        } else {
            a._mode = e;
            $common.setVisible(c, false);
            a.invalidate();
            $common.setVisible(b, d);
            $common.setLocation(b, {
                x: 0,
                y: 0
            })
        }
    },
    _isSelected: function(c, d) {
        var a = false
          , b = this.get_selectedDate();
        if (!b)
            return a;
        switch (d) {
        case "d":
            if (c.getDate() != b.getDate())
                return a;
        case "M":
            if (c.getMonth() != b.getMonth())
                return a;
        case "y":
            if (c.getFullYear() != b.getFullYear())
                return a
        }
        return true
    },
    _isOther: function(a, d) {
        var b = this._getEffectiveVisibleDate();
        switch (d) {
        case "d":
            return a.getFullYear() != b.getFullYear() || a.getMonth() != b.getMonth();
        case "M":
            return false;
        case "y":
            var c = Math.floor(b.getFullYear() / 10) * 10;
            return a.getFullYear() < c || c + 10 <= a.getFullYear()
        }
        return false
    },
    _getCssClass: function(a, b) {
        if (this._isSelected(a, b))
            return "ajax__calendar_active";
        else if (this._isOther(a, b))
            return "ajax__calendar_other";
        else
            return ""
    },
    _getEffectiveVisibleDate: function() {
        var b = this
          , a = b.get_visibleDate();
        if (a == null)
            a = b.get_selectedDate();
        if (a == null)
            a = b.get_todaysDate();
        return new Date(a.getFullYear(),a.getMonth(),1,b._hourOffsetForDst)
    },
    _getFirstDayOfWeek: function() {
        if (this.get_firstDayOfWeek() != AjaxControlToolkit.FirstDayOfWeek.Default)
            return this.get_firstDayOfWeek();
        return Sys.CultureInfo.CurrentCulture.dateTimeFormat.FirstDayOfWeek
    },
    _parseTextValue: function(b) {
        var a = null;
        if (b)
            a = Date.parseLocale(b, this.get_format());
        if (isNaN(a))
            a = null;
        return a
    },
    _element_onfocus: function() {
        var a = this;
        if (!a._enabled)
            return;
        if (!a._button) {
            a.show();
            a._popupMouseDown = false
        }
    },
    _element_onblur: function() {
        if (!this._enabled)
            return;
        !this._button && this.blur()
    },
    _element_onchange: function() {
        var a = this;
        if (!a._selectedDateChanging) {
            var b = a._parseTextValue(a._textbox.get_Value());
            if (b)
                b = b.getDateOnly();
            a._selectedDate = b;
            a._isOpen && a._switchMonth(a._selectedDate, a._selectedDate == null)
        }
    },
    _element_onkeypress: function(a) {
        if (!this._enabled)
            return;
        if (!this._button && a.charCode == Sys.UI.Key.esc) {
            a.stopPropagation();
            a.preventDefault();
            this.hide()
        }
    },
    _element_onclick: function() {
        var a = this;
        if (!a._enabled)
            return;
        if (!a._button) {
            a.show();
            a._popupMouseDown = false
        }
    },
    _popup_onevent: function(a) {
        a.stopPropagation();
        a.preventDefault()
    },
    _popup_onmousedown: function() {
        this._popupMouseDown = true
    },
    _popup_onmouseup: function() {
        var a = this;
        Sys.Browser.agent === Sys.Browser.Opera && a._blur.get_isPending() && a._blur.cancel();
        a._popupMouseDown = false;
        a.focus()
    },
    _cell_onmouseover: function(e) {
        var c = "ajax__calendar_hover";
        e.stopPropagation();
        if (Sys.Browser.agent === Sys.Browser.Safari)
            for (var a = 0; a < this._daysBody.rows.length; a++)
                for (var d = this._daysBody.rows[a], b = 0; b < d.cells.length; b++)
                    Sys.UI.DomElement.removeCssClass(d.cells[b].firstChild.parentNode, c);
        var f = e.target;
        Sys.UI.DomElement.addCssClass(f.parentNode, c)
    },
    _cell_onmouseout: function(a) {
        a.stopPropagation();
        var b = a.target;
        Sys.UI.DomElement.removeCssClass(b.parentNode, "ajax__calendar_hover")
    },
    _cell_onclick: function(e) {
        var c = "months"
          , d = "days"
          , a = this;
        e.stopPropagation();
        e.preventDefault();
        if (!a._enabled)
            return;
        var b = e.target
          , f = a._getEffectiveVisibleDate();
        Sys.UI.DomElement.removeCssClass(b.parentNode, "ajax__calendar_hover");
        switch (b.mode) {
        case "prev":
        case "next":
            a._switchMonth(b.date);
            break;
        case "title":
            switch (a._mode) {
            case d:
                a._switchMode(c);
                break;
            case c:
                a._switchMode("years")
            }
            break;
        case "month":
            if (b.month == f.getMonth())
                a._switchMode(d);
            else {
                a._visibleDate = b.date;
                a._switchMode(d)
            }
            break;
        case "year":
            if (b.date.getFullYear() == f.getFullYear())
                a._switchMode(c);
            else {
                a._visibleDate = b.date;
                a._switchMode(c)
            }
            break;
        case "day":
            a.set_selectedDate(b.date);
            a._switchMonth(b.date);
            a._blur.post(true);
            a.raiseDateSelectionChanged();
            break;
        case "today":
            a.set_selectedDate(b.date);
            a._switchMonth(b.date);
            a._blur.post(true);
            a.raiseDateSelectionChanged()
        }
    },
    _button_onclick: function(b) {
        var a = this;
        b.preventDefault();
        b.stopPropagation();
        if (!a._enabled)
            return;
        if (!a._isOpen)
            a.show();
        else
            a.hide();
        a.focus();
        a._popupMouseDown = false
    },
    _button_onblur: function() {
        var a = this;
        if (!a._enabled)
            return;
        !a._popupMouseDown && a.hide();
        a._popupMouseDown = false
    },
    _button_onkeypress: function(a) {
        if (!this._enabled)
            return;
        if (a.charCode == Sys.UI.Key.esc) {
            a.stopPropagation();
            a.preventDefault();
            this.hide()
        }
        this._popupMouseDown = false
    }
};
AjaxControlToolkit.CalendarBehavior.registerClass("AjaxControlToolkit.CalendarBehavior", AjaxControlToolkit.BehaviorBase);
AjaxControlToolkit.CalendarPosition = function() {
    throw Error.invalidOperation();
}
;
AjaxControlToolkit.CalendarPosition.prototype = {
    BottomLeft: 0,
    BottomRight: 1,
    TopLeft: 2,
    TopRight: 3,
    Right: 4,
    Left: 5
};
AjaxControlToolkit.CalendarPosition.registerEnum("AjaxControlToolkit.CalendarPosition");
AjaxControlToolkit.CalendarDefaultView = function() {
    throw Error.invalidOperation();
}
;
AjaxControlToolkit.CalendarDefaultView.prototype = {
    Days: 0,
    Months: 1,
    Years: 2
};
AjaxControlToolkit.CalendarDefaultView.registerEnum("AjaxControlToolkit.CalendarDefaultView");
//END AjaxControlToolkit.Calendar.CalendarBehavior.js
//START AjaxControlToolkit.CollapsiblePanel.CollapsiblePanelBehavior.js
Type.registerNamespace("AjaxControlToolkit");
AjaxControlToolkit.CollapsiblePanelExpandDirection = function() {
    throw Error.invalidOperation();
}
;
AjaxControlToolkit.CollapsiblePanelExpandDirection.prototype = {
    Horizontal: 0,
    Vertical: 1
};
AjaxControlToolkit.CollapsiblePanelExpandDirection.registerEnum("AjaxControlToolkit.CollapsiblePanelExpandDirection", false);
AjaxControlToolkit.CollapsiblePanelBehavior = function(c) {
    var b = null
      , a = this;
    AjaxControlToolkit.CollapsiblePanelBehavior.initializeBase(a, [c]);
    a._collapsedSize = 0;
    a._expandedSize = 0;
    a._scrollContents = b;
    a._collapsed = false;
    a._expandControlID = b;
    a._collapseControlID = b;
    a._textLabelID = b;
    a._collapsedText = b;
    a._expandedText = b;
    a._imageControlID = b;
    a._expandedImage = b;
    a._collapsedImage = b;
    a._suppressPostBack = b;
    a._autoExpand = b;
    a._autoCollapse = b;
    a._expandDirection = AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical;
    a._collapseClickHandler = b;
    a._expandClickHandler = b;
    a._panelMouseEnterHandler = b;
    a._panelMouseLeaveHandler = b;
    a._childDiv = b;
    a._animation = b
}
;
AjaxControlToolkit.CollapsiblePanelBehavior.prototype = {
    initialize: function() {
        var f = "SuppressPostBack"
          , a = this;
        AjaxControlToolkit.CollapsiblePanelBehavior.callBaseMethod(a, "initialize");
        var b = a.get_element();
        a._animation = new AjaxControlToolkit.Animation.LengthAnimation(b,.25,10,"style",null,0,0,"px");
        if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical)
            a._animation.set_propertyKey("height");
        else
            a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Horizontal && a._animation.set_propertyKey("width");
        a._animation.add_ended(Function.createDelegate(a, a._onAnimateComplete));
        if (a._suppressPostBack == null)
            if (b.tagName == "INPUT" && b.type == "checkbox") {
                a._suppressPostBack = false;
                a.raisePropertyChanged(f)
            } else if (b.tagName == "A") {
                a._suppressPostBack = true;
                a.raisePropertyChanged(f)
            }
        var c = AjaxControlToolkit.CollapsiblePanelBehavior.callBaseMethod(a, "get_ClientState");
        if (c && c != "") {
            var g = Boolean.parse(c);
            if (a._collapsed != g) {
                a._collapsed = g;
                a.raisePropertyChanged("Collapsed")
            }
        }
        a._setupChildDiv();
        if (a._collapsed)
            a._setTargetSize(a._getCollapsedSize());
        else
            a._setTargetSize(a._getExpandedSize());
        a._setupState(a._collapsed);
        if (a._collapseControlID == a._expandControlID) {
            a._collapseClickHandler = Function.createDelegate(a, a.togglePanel);
            a._expandClickHandler = null
        } else {
            a._collapseClickHandler = Function.createDelegate(a, a.collapsePanel);
            a._expandClickHandler = Function.createDelegate(a, a.expandPanel)
        }
        if (a._autoExpand) {
            a._panelMouseEnterHandler = Function.createDelegate(a, a._onMouseEnter);
            $addHandler(b, "mouseover", a._panelMouseEnterHandler)
        }
        if (a._autoCollapse) {
            a._panelMouseLeaveHandler = Function.createDelegate(a, a._onMouseLeave);
            $addHandler(b, "mouseout", a._panelMouseLeaveHandler)
        }
        if (a._collapseControlID) {
            var d = $get(a._collapseControlID);
            if (!d)
                throw Error.argument("CollapseControlID", String.format(AjaxControlToolkit.Resources.CollapsiblePanel_NoControlID, a._collapseControlID));
            else
                $addHandler(d, "click", a._collapseClickHandler)
        }
        if (a._expandControlID)
            if (a._expandClickHandler) {
                var e = $get(a._expandControlID);
                if (!e)
                    throw Error.argument("ExpandControlID", String.format(AjaxControlToolkit.Resources.CollapsiblePanel_NoControlID, a._expandControlID));
                else
                    $addHandler(e, "click", a._expandClickHandler)
            }
    },
    dispose: function() {
        var b = null
          , a = this
          , e = a.get_element();
        if (a._collapseClickHandler) {
            var c = a._collapseControlID ? $get(a._collapseControlID) : b;
            c && $removeHandler(c, "click", a._collapseClickHandler);
            a._collapseClickHandler = b
        }
        if (a._expandClickHandler) {
            var d = a._expandControlID ? $get(a._expandControlID) : b;
            d && $removeHandler(d, "click", a._expandClickHandler);
            a._expandClickHandler = b
        }
        a._panelMouseEnterHandler && $removeHandler(e, "mouseover", a._panelMouseEnterHandler);
        a._panelMouseLeaveHandler && $removeHandler(e, "mouseout", a._panelMouseLeaveHandler);
        if (a._animation) {
            a._animation.dispose();
            a._animation = b
        }
        AjaxControlToolkit.CollapsiblePanelBehavior.callBaseMethod(a, "dispose")
    },
    togglePanel: function(a) {
        this._toggle(a)
    },
    expandPanel: function(a) {
        this._doOpen(a)
    },
    collapsePanel: function(a) {
        this._doClose(a)
    },
    _checkCollapseHide: function() {
        if (this._collapsed && this._getTargetSize() == 0) {
            var a = this.get_element()
              , b = $common.getCurrentStyle(a, "display");
            if (!a.oldDisplay && b != "none") {
                a.oldDisplay = b;
                a.style.display = "none"
            }
            return true
        }
        return false
    },
    _doClose: function(b) {
        var a = this
          , c = new Sys.CancelEventArgs;
        a.raiseCollapsing(c);
        if (c.get_cancel())
            return;
        if (a._animation) {
            a._animation.stop();
            a._animation.set_startValue(a._getTargetSize());
            a._animation.set_endValue(a._getCollapsedSize());
            a._animation.play()
        }
        a._setupState(true);
        if (a._suppressPostBack)
            if (b && b.preventDefault)
                b.preventDefault();
            else {
                if (b)
                    b.returnValue = false;
                return false
            }
    },
    _doOpen: function(c) {
        var d = "display"
          , a = this
          , e = new Sys.CancelEventArgs;
        a.raiseExpanding(e);
        if (e.get_cancel())
            return;
        if (a._animation) {
            a._animation.stop();
            var b = a.get_element();
            if (a._checkCollapseHide() && $common.getCurrentStyle(b, d, b.style.display)) {
                if (b.oldDisplay)
                    b.style.display = b.oldDisplay;
                else if (b.style.removeAttribute)
                    b.style.removeAttribute(d);
                else
                    b.style.removeProperty(d);
                b.oldDisplay = null
            }
            a._animation.set_startValue(a._getTargetSize());
            a._animation.set_endValue(a._getExpandedSize());
            a._animation.play()
        }
        a._setupState(false);
        if (a._suppressPostBack)
            if (c && c.preventDefault)
                c.preventDefault();
            else {
                if (c)
                    c.returnValue = false;
                return false
            }
    },
    _onAnimateComplete: function() {
        var a = this
          , b = a.get_element();
        if (!a._collapsed && !a._expandedSize)
            if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical)
                if (a._childDiv.offsetHeight <= b.offsetHeight) {
                    b.style.height = "auto";
                    a.raisePropertyChanged("TargetHeight")
                } else
                    a._checkCollapseHide();
            else if (a._childDiv.offsetWidth <= b.offsetWidth) {
                b.style.width = "auto";
                a.raisePropertyChanged("TargetWidth")
            } else
                a._checkCollapseHide();
        else
            a._checkCollapseHide();
        if (a._collapsed) {
            a.raiseCollapseComplete();
            a.raiseCollapsed(Sys.EventArgs.Empty)
        } else {
            a.raiseExpandComplete();
            a.raiseExpanded(new Sys.EventArgs)
        }
    },
    _onMouseEnter: function(a) {
        this._autoExpand && this.expandPanel(a)
    },
    _onMouseLeave: function(a) {
        this._autoCollapse && this.collapsePanel(a)
    },
    _getExpandedSize: function() {
        var a = this;
        if (a._expandedSize)
            return a._expandedSize;
        if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical)
            return a._childDiv.offsetHeight;
        else if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Horizontal)
            return a._childDiv.offsetWidth
    },
    _getCollapsedSize: function() {
        if (this._collapsedSize)
            return this._collapsedSize;
        return 0
    },
    _getTargetSize: function() {
        var b = this, a;
        if (b._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical)
            a = b.get_TargetHeight();
        else if (b._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Horizontal)
            a = b.get_TargetWidth();
        if (a === undefined)
            a = 0;
        return a
    },
    _setTargetSize: function(b) {
        var a = this
          , d = a._collapsed || a._expandedSize
          , c = a.get_element();
        if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical)
            if (d || b < c.offsetHeight)
                a.set_TargetHeight(b);
            else {
                c.style.height = "auto";
                a.raisePropertyChanged("TargetHeight")
            }
        else if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Horizontal)
            if (d || b < c.offsetWidth)
                a.set_TargetWidth(b);
            else {
                c.style.width = "auto";
                a.raisePropertyChanged("TargetWidth")
            }
        a._checkCollapseHide()
    },
    _setupChildDiv: function() {
        var f = "px"
          , d = "auto"
          , h = "hidden"
          , g = "scroll"
          , c = ""
          , a = this
          , e = a._getTargetSize()
          , b = a.get_element();
        a._childDiv = b.cloneNode(false);
        b.id = c;
        a._childDiv.style.visibility = "visible";
        a._childDiv.style.display = c;
        while (b.hasChildNodes()) {
            var i = b.childNodes[0];
            i = b.removeChild(i);
            a._childDiv.appendChild(i)
        }
        b.setAttribute("style", c);
        b.className = c;
        b.style.border = "0px";
        b.style.margin = "0px";
        b.style.padding = "0px";
        if (a._scrollContents) {
            if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical) {
                b.style.overflowY = g;
                a._childDiv.style.overflowY = c
            } else {
                b.style.overflowX = g;
                a._childDiv.style.overflowX = c
            }
            if (Sys.Browser.agent == Sys.Browser.Safari || Sys.Browser.agent == Sys.Browser.Opera) {
                b.style.overflow = g;
                a._childDiv.style.overflow = c
            }
        } else {
            if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical) {
                b.style.overflowY = h;
                a._childDiv.style.overflowY = c
            } else {
                b.style.overflowX = h;
                a._childDiv.style.overflowX = c
            }
            if (Sys.Browser.Agent == Sys.Browser.Safari || Sys.Browser.Agent == Sys.Browser.Opera) {
                b.style.overflow = h;
                a._childDiv.style.overflow = c
            }
        }
        a._childDiv.style.position = c;
        if (e == a._collapsedSize)
            if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical)
                a._childDiv.style.height = d;
            else if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Horizontal)
                a._childDiv.style.width = d;
        b.appendChild(a._childDiv);
        b.style.visibility = "visible";
        b.style.display = c;
        if (a._collapsed)
            e = a._getCollapsedSize();
        else
            e = a._getExpandedSize();
        if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical) {
            b.style.height = e + f;
            if (!a._expandedSize)
                b.style.height = d;
            else
                b.style.height = a._expandedSize + f;
            a._childDiv.style.height = d
        } else if (a._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Horizontal) {
            b.style.width = e + f;
            if (!a._expandedSize)
                b.style.width = d;
            else
                b.style.width = a._expandedSize + f;
            a._childDiv.style.width = d
        }
    },
    _setupState: function(d) {
        var a = this;
        if (d) {
            if (a._textLabelID && a._collapsedText) {
                var c = $get(a._textLabelID);
                if (c)
                    c.innerHTML = a._collapsedText
            }
            if (a._imageControlID && a._collapsedImage) {
                var b = $get(a._imageControlID);
                if (b && b.src) {
                    b.src = a._collapsedImage;
                    if (a._expandedText || a._collapsedText)
                        b.title = a._collapsedText
                }
            }
        } else {
            if (a._textLabelID && a._expandedText) {
                var c = $get(a._textLabelID);
                if (c)
                    c.innerHTML = a._expandedText
            }
            if (a._imageControlID && a._expandedImage) {
                var b = $get(a._imageControlID);
                if (b && b.src) {
                    b.src = a._expandedImage;
                    if (a._expandedText || a._collapsedText)
                        b.title = a._expandedText
                }
            }
        }
        if (a._collapsed != d) {
            a._collapsed = d;
            a.raisePropertyChanged("Collapsed")
        }
        AjaxControlToolkit.CollapsiblePanelBehavior.callBaseMethod(a, "set_ClientState", [a._collapsed.toString()])
    },
    _toggle: function(a) {
        if (this.get_Collapsed())
            return this.expandPanel(a);
        else
            return this.collapsePanel(a)
    },
    add_collapsing: function(a) {
        this.get_events().addHandler("collapsing", a)
    },
    remove_collapsing: function(a) {
        this.get_events().removeHandler("collapsing", a)
    },
    raiseCollapsing: function(b) {
        var a = this.get_events().getHandler("collapsing");
        a && a(this, b)
    },
    add_collapsed: function(a) {
        this.get_events().addHandler("collapsed", a)
    },
    remove_collapsed: function(a) {
        this.get_events().removeHandler("collapsed", a)
    },
    raiseCollapsed: function(b) {
        var a = this.get_events().getHandler("collapsed");
        a && a(this, b)
    },
    add_collapseComplete: function(a) {
        this.get_events().addHandler("collapseComplete", a)
    },
    remove_collapseComplete: function(a) {
        this.get_events().removeHandler("collapseComplete", a)
    },
    raiseCollapseComplete: function() {
        var a = this.get_events().getHandler("collapseComplete");
        a && a(this, Sys.EventArgs.Empty)
    },
    add_expanding: function(a) {
        this.get_events().addHandler("expanding", a)
    },
    remove_expanding: function(a) {
        this.get_events().removeHandler("expanding", a)
    },
    raiseExpanding: function(b) {
        var a = this.get_events().getHandler("expanding");
        a && a(this, b)
    },
    add_expanded: function(a) {
        this.get_events().addHandler("expanded", a)
    },
    remove_expanded: function(a) {
        this.get_events().removeHandler("expanded", a)
    },
    raiseExpanded: function(b) {
        var a = this.get_events().getHandler("expanded");
        a && a(this, b)
    },
    add_expandComplete: function(a) {
        this.get_events().addHandler("expandComplete", a)
    },
    remove_expandComplete: function(a) {
        this.get_events().removeHandler("expandComplete", a)
    },
    raiseExpandComplete: function() {
        var a = this.get_events().getHandler("expandComplete");
        a && a(this, Sys.EventArgs.Empty)
    },
    get_TargetHeight: function() {
        return this.get_element().offsetHeight
    },
    set_TargetHeight: function(a) {
        this.get_element().style.height = a + "px";
        this.raisePropertyChanged("TargetHeight")
    },
    get_TargetWidth: function() {
        return this.get_element().offsetWidth
    },
    set_TargetWidth: function(a) {
        this.get_element().style.width = a + "px";
        this.raisePropertyChanged("TargetWidth")
    },
    get_Collapsed: function() {
        return this._collapsed
    },
    set_Collapsed: function(b) {
        var a = this;
        if (a.get_isInitialized() && a.get_element() && b != a.get_Collapsed())
            a.togglePanel();
        else {
            a._collapsed = b;
            a.raisePropertyChanged("Collapsed")
        }
    },
    get_CollapsedSize: function() {
        return this._collapsedSize
    },
    set_CollapsedSize: function(a) {
        if (this._collapsedSize != a) {
            this._collapsedSize = a;
            this.raisePropertyChanged("CollapsedSize")
        }
    },
    get_ExpandedSize: function() {
        return this._expandedSize
    },
    set_ExpandedSize: function(a) {
        if (this._expandedSize != a) {
            this._expandedSize = a;
            this.raisePropertyChanged("ExpandedSize")
        }
    },
    get_CollapseControlID: function() {
        return this._collapseControlID
    },
    set_CollapseControlID: function(a) {
        if (this._collapseControlID != a) {
            this._collapseControlID = a;
            this.raisePropertyChanged("CollapseControlID")
        }
    },
    get_ExpandControlID: function() {
        return this._expandControlID
    },
    set_ExpandControlID: function(a) {
        if (this._expandControlID != a) {
            this._expandControlID = a;
            this.raisePropertyChanged("ExpandControlID")
        }
    },
    get_ScrollContents: function() {
        return this._scrollContents
    },
    set_ScrollContents: function(a) {
        if (this._scrollContents != a) {
            this._scrollContents = a;
            this.raisePropertyChanged("ScrollContents")
        }
    },
    get_SuppressPostBack: function() {
        return this._suppressPostBack
    },
    set_SuppressPostBack: function(a) {
        if (this._suppressPostBack != a) {
            this._suppressPostBack = a;
            this.raisePropertyChanged("SuppressPostBack")
        }
    },
    get_TextLabelID: function() {
        return this._textLabelID
    },
    set_TextLabelID: function(a) {
        if (this._textLabelID != a) {
            this._textLabelID = a;
            this.raisePropertyChanged("TextLabelID")
        }
    },
    get_ExpandedText: function() {
        return this._expandedText
    },
    set_ExpandedText: function(a) {
        if (this._expandedText != a) {
            this._expandedText = a;
            this.raisePropertyChanged("ExpandedText")
        }
    },
    get_CollapsedText: function() {
        return this._collapsedText
    },
    set_CollapsedText: function(a) {
        if (this._collapsedText != a) {
            this._collapsedText = a;
            this.raisePropertyChanged("CollapsedText")
        }
    },
    get_ImageControlID: function() {
        return this._imageControlID
    },
    set_ImageControlID: function(a) {
        if (this._imageControlID != a) {
            this._imageControlID = a;
            this.raisePropertyChanged("ImageControlID")
        }
    },
    get_ExpandedImage: function() {
        return this._expandedImage
    },
    set_ExpandedImage: function(a) {
        if (this._expandedImage != a) {
            this._expandedImage = a;
            this.raisePropertyChanged("ExpandedImage")
        }
    },
    get_CollapsedImage: function() {
        return this._collapsedImage
    },
    set_CollapsedImage: function(a) {
        if (this._collapsedImage != a) {
            this._collapsedImage = a;
            this.raisePropertyChanged("CollapsedImage")
        }
    },
    get_AutoExpand: function() {
        return this._autoExpand
    },
    set_AutoExpand: function(a) {
        if (this._autoExpand != a) {
            this._autoExpand = a;
            this.raisePropertyChanged("AutoExpand")
        }
    },
    get_AutoCollapse: function() {
        return this._autoCollapse
    },
    set_AutoCollapse: function(a) {
        if (this._autoCollapse != a) {
            this._autoCollapse = a;
            this.raisePropertyChanged("AutoCollapse")
        }
    },
    get_ExpandDirection: function() {
        return this._expandDirection == AjaxControlToolkit.CollapsiblePanelExpandDirection.Vertical
    },
    set_ExpandDirection: function(a) {
        if (this._expandDirection != a) {
            this._expandDirection = a;
            this.raisePropertyChanged("ExpandDirection")
        }
    }
};
AjaxControlToolkit.CollapsiblePanelBehavior.registerClass("AjaxControlToolkit.CollapsiblePanelBehavior", AjaxControlToolkit.BehaviorBase);
//END AjaxControlToolkit.CollapsiblePanel.CollapsiblePanelBehavior.js
if (typeof (Sys) !== 'undefined')
    Sys.Application.notifyScriptLoaded();
(function() {
    var fn = function() {
        $get('ctl00_SampleContent_ScriptManager1_HiddenField').value += ';;AjaxControlToolkit, Version=3.0.30930.28755, Culture=neutral, PublicKeyToken=28f01b0e84b6d53e:en:6f3150d4-f637-4a20-b84e-67a2beba7f91:865923e8:9b7907bc:411fea1c:e7c87f07:91bd373d:bbfda34c:30a78ec5:9349f837:d4245214:d72169a4';
        Sys.Application.remove_load(fn);
    };
    Sys.Application.add_load(fn);
}
)();
